/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool2;

import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.utils.connectionpool2.CachedDriverManagerMBean;
import org.apache.plc4x.java.utils.connectionpool2.CachedPlcConnection;
import org.apache.plc4x.java.utils.connectionpool2.PlcConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDriverManager
extends PlcDriverManager
implements CachedDriverManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(CachedDriverManager.class);
    public static final int LONG_BORROW_WATCHDOG_TIMEOUT_MS = 5000;
    private final AtomicInteger numberOfConnects = new AtomicInteger(0);
    private final AtomicInteger numberOfBorrows = new AtomicInteger(0);
    private final AtomicInteger numberOfRejections = new AtomicInteger(0);
    private final AtomicInteger numberOfWatchdogs = new AtomicInteger(0);
    private final String url;
    private final PlcConnectionFactory connectionFactory;
    private final Queue<CompletableFuture<PlcConnection>> queue = new LinkedList<CompletableFuture<PlcConnection>>();
    private final int timeoutMillis;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private AtomicReference<ConnectionState> state = new AtomicReference<ConnectionState>(ConnectionState.DISCONNECTED);
    private PlcConnection activeConnection;
    private CachedPlcConnection borrowedConnection;
    private ScheduledFuture<?> borrowWatchdog;

    public CachedDriverManager(String url, PlcConnectionFactory connectionFactory) {
        this(url, connectionFactory, 1000);
    }

    public CachedDriverManager(String url, PlcConnectionFactory connectionFactory, int timeoutMillis) {
        logger.info("Creating new cached Connection for url {} with timeout {} ms", (Object)url, (Object)timeoutMillis);
        this.url = url;
        this.connectionFactory = connectionFactory;
        this.timeoutMillis = timeoutMillis;
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, new ObjectName("org.apache.plc4x.plc:name=cached-driver-manager,url=\"" + url + "\""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void returnConnection(PlcConnection activeConnection) {
        logger.debug("Borrowed Connection is closed and returned.");
        this.cancelWatchdog();
        if (this.state.get() == ConnectionState.DISCONNECTED) {
            logger.trace("Connection already disconnected");
            return;
        }
        if (this.state.get() != ConnectionState.BORROWED) {
            logger.warn("Connection was returned, although it is not borrowed, currently.");
        }
        this.borrowedConnection = null;
        this.setState(ConnectionState.AVAILABLE);
        this.checkQueue();
        logger.trace("Connection successfully returned");
    }

    private void setState(ConnectionState available) {
        logger.trace("Setting State from {} to {}", (Object)this.state.get(), (Object)available);
        this.state.set(available);
    }

    public synchronized void handleBrokenConnection() {
        logger.debug("Connection was detected as broken and is invalidated in Cached Manager");
        this.cancelWatchdog();
        if (this.state.get() != ConnectionState.BORROWED) {
            logger.warn("Broken Connection was returned, although it is not borrowed, currently.");
        }
        this.borrowedConnection = null;
        try {
            this.activeConnection.close();
        }
        catch (Exception e) {
            logger.debug("Unable to Close 'broken' Connection", (Throwable)e);
        }
        this.activeConnection = null;
        this.setState(ConnectionState.DISCONNECTED);
    }

    public boolean isConnectionAvailable() {
        return this.getState().equals((Object)ConnectionState.AVAILABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlcConnection getConnection(String url) throws PlcConnectionException {
        CompletableFuture future;
        if (!this.url.equals(url)) {
            throw new IllegalArgumentException("This Cached Driver Manager only supports the Connection " + url);
        }
        CachedDriverManager cachedDriverManager = this;
        synchronized (cachedDriverManager) {
            logger.trace("current queue size before check {}", (Object)this.queue.size());
            if (this.queue.isEmpty() && this.isConnectionAvailable()) {
                logger.trace("queue is empty and a connection is available");
                return this.getConnection_(url);
            }
            logger.trace("Getting a connection and instantly close it");
            try {
                this.getConnection_(url).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            future = new CompletableFuture();
            logger.trace("current queue size before add {}", (Object)this.queue.size());
            this.queue.add(future);
        }
        try {
            cachedDriverManager = (PlcConnection)future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            return cachedDriverManager;
        }
        catch (ExecutionException | TimeoutException e) {
            this.handleBrokenConnection();
            throw new PlcConnectionException("No Connection Available, timed out while waiting in queue.", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.handleBrokenConnection();
            Thread.currentThread().interrupt();
            throw new PlcConnectionException("No Connection Available, interrupted while waiting in queue.", (Throwable)e);
        }
        finally {
            future.cancel(true);
        }
    }

    private synchronized PlcConnection getConnection_(String url) throws PlcConnectionException {
        logger.trace("Current State {}", (Object)this.state.get());
        switch (this.state.get()) {
            case AVAILABLE: {
                logger.debug("Connection was requested and is available, thus, returning Chached Connection for usage");
                this.setState(ConnectionState.BORROWED);
                this.numberOfBorrows.incrementAndGet();
                this.borrowedConnection = new CachedPlcConnection(this, this.activeConnection);
                this.startWatchdog(this.borrowedConnection);
                return this.borrowedConnection;
            }
            case DISCONNECTED: {
                logger.debug("Connection was requested but no connection is active, trying to establish a Connection");
                this.setState(ConnectionState.CONNECTING);
                this.numberOfConnects.incrementAndGet();
                CompletableFuture.runAsync(() -> {
                    logger.debug("Starting to establish Connection");
                    try {
                        PlcConnection connection = this.connectionFactory.create();
                        logger.debug("Connection successfully established");
                        CachedDriverManager cachedDriverManager = this;
                        synchronized (cachedDriverManager) {
                            this.activeConnection = connection;
                            this.setState(ConnectionState.AVAILABLE);
                            this.checkQueue();
                            logger.trace("Inline queue check succeeded");
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Unable to establish connection to PLC {}", (Object)url, (Object)e);
                        this.setState(ConnectionState.DISCONNECTED);
                    }
                });
                this.numberOfRejections.incrementAndGet();
                throw new PlcConnectionException("No Connection Available, Starting Connection");
            }
            case CONNECTING: {
                logger.debug("Connection was requsted, but currently establishing one, so none available");
                this.numberOfRejections.incrementAndGet();
                throw new PlcConnectionException("No Connection Available, Currently Connecting");
            }
            case BORROWED: {
                logger.debug("Connection was requsted, but Connection currently is borrowed, so none available");
                this.numberOfRejections.incrementAndGet();
                throw new PlcConnectionException("No Connection Available, its in Use");
            }
        }
        throw new IllegalStateException();
    }

    private synchronized void checkQueue() {
        CompletableFuture<PlcConnection> next;
        logger.debug("Connection is available, checking if someone is waiting in the queue...");
        logger.trace("current queue size before check queue {}", (Object)this.queue.size());
        while ((next = this.queue.poll()) != null) {
            if (next.isCancelled()) {
                logger.trace("Cleaning up already timed out connection...");
                continue;
            }
            try {
                next.complete(this.getConnection_(this.url));
                return;
            }
            catch (PlcConnectionException e) {
                logger.debug("Got an Exception on fetching a connection", (Throwable)e);
            }
        }
        logger.trace("check queue ended");
    }

    private void startWatchdog(CachedPlcConnection connection) {
        this.borrowWatchdog = this.executorService.schedule(() -> {
            logger.warn("Watchdog detected a long borrowed connection, will be forcefully closed!");
            this.numberOfWatchdogs.incrementAndGet();
            this.handleBrokenConnection();
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.warn("Unable to close the borrowed Connection from Watchdog", (Throwable)e);
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    private void cancelWatchdog() {
        if (this.borrowWatchdog != null) {
            this.borrowWatchdog.cancel(false);
        }
    }

    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new NotImplementedException("");
    }

    public ConnectionState getState() {
        return this.state.get();
    }

    @Override
    public String getStateString() {
        return this.getState().toString();
    }

    @Override
    public int getNumberOfConnects() {
        return this.numberOfConnects.get();
    }

    @Override
    public int getNumberOfBorrows() {
        return this.numberOfBorrows.get();
    }

    @Override
    public int getNumberOfRejections() {
        return this.numberOfRejections.get();
    }

    @Override
    public int getNumberOfWachtdogs() {
        return this.numberOfWatchdogs.get();
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public synchronized void triggerReconnect() {
        logger.info("Disconnecting current connection, was triggered from external via JMX");
        this.handleBrokenConnection();
        if (this.state.get() == ConnectionState.BORROWED) {
            try {
                this.borrowedConnection.close();
            }
            catch (Exception e) {
                logger.warn("Unable to close the borrowed Connection from JMX", (Throwable)e);
            }
        }
    }

    static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        AVAILABLE,
        BORROWED;

    }
}

