/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.cache;

import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.utils.cache.LeasedPlcConnection;

class ConnectionContainer {
    private final PlcConnectionManager connectionManager;
    private final String connectionUrl;
    private final Duration maxLeaseTime;
    private final Queue<CompletableFuture<PlcConnection>> queue;
    private PlcConnection connection;
    private LeasedPlcConnection leasedConnection;

    public ConnectionContainer(PlcConnectionManager connectionManager, String connectionUrl, Duration maxLeaseTime) {
        this.connectionManager = connectionManager;
        this.connectionUrl = connectionUrl;
        this.maxLeaseTime = maxLeaseTime;
        this.queue = new LinkedList<CompletableFuture<PlcConnection>>();
        this.connection = null;
        this.leasedConnection = null;
    }

    public synchronized Future<PlcConnection> lease() {
        CompletableFuture<PlcConnection> connectionFuture = new CompletableFuture<PlcConnection>();
        if (this.connection == null) {
            try {
                this.connection = this.connectionManager.getConnection(this.connectionUrl);
            }
            catch (PlcConnectionException e) {
                connectionFuture.completeExceptionally(e);
                return connectionFuture;
            }
        }
        if (this.leasedConnection == null) {
            this.leasedConnection = new LeasedPlcConnection(this, this.connection, this.maxLeaseTime);
            connectionFuture.complete(this.leasedConnection);
        } else {
            this.queue.add(connectionFuture);
        }
        return connectionFuture;
    }

    public synchronized void returnConnection(LeasedPlcConnection returnedLeasedConnection, boolean invalidateConnection) {
        if (returnedLeasedConnection != this.leasedConnection) {
            throw new PlcRuntimeException("Error trying to return lease from invalid connection");
        }
        if (invalidateConnection) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.connection = this.connectionManager.getConnection(this.connectionUrl);
            }
            catch (PlcConnectionException e) {
                this.queue.forEach(future -> {
                    boolean bl = future.completeExceptionally(e);
                });
            }
        }
        if (this.queue.isEmpty()) {
            this.leasedConnection = null;
            return;
        }
        this.leasedConnection = new LeasedPlcConnection(this, this.connection, this.maxLeaseTime);
        CompletableFuture<PlcConnection> leaseFuture = this.queue.poll();
        if (leaseFuture != null) {
            leaseFuture.complete(this.leasedConnection);
        }
    }
}

