/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.abeth.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CIPEncapsulationReadResponse extends CIPEncapsulationPacket implements Message {

  // Accessors for discriminator values.
  public Integer getCommandType() {
    return (int) 0x0207;
  }

  // Properties.
  protected final DF1ResponseMessage response;

  // Arguments.
  protected final Integer packetLen;

  public CIPEncapsulationReadResponse(
      long sessionHandle,
      long status,
      List<Short> senderContext,
      long options,
      DF1ResponseMessage response,
      Integer packetLen) {
    super(sessionHandle, status, senderContext, options);
    this.response = response;
    this.packetLen = packetLen;
  }

  public DF1ResponseMessage getResponse() {
    return response;
  }

  @Override
  protected void serializeCIPEncapsulationPacketChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CIPEncapsulationReadResponse");

    // Simple Field (response)
    writeSimpleField(
        "response",
        response,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("CIPEncapsulationReadResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CIPEncapsulationReadResponse _value = this;

    // Simple field (response)
    lengthInBits += response.getLengthInBits();

    return lengthInBits;
  }

  public static CIPEncapsulationReadResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Integer packetLen) throws ParseException {
    readBuffer.pullContext("CIPEncapsulationReadResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    DF1ResponseMessage response =
        readSimpleField(
            "response",
            new DataReaderComplexDefault<>(
                () -> DF1ResponseMessage.staticParse(readBuffer, (int) (packetLen)), readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("CIPEncapsulationReadResponse");
    // Create the instance
    return new CIPEncapsulationReadResponseBuilder(response, packetLen);
  }

  public static class CIPEncapsulationReadResponseBuilder
      implements CIPEncapsulationPacket.CIPEncapsulationPacketBuilder {
    private final DF1ResponseMessage response;
    private final Integer packetLen;

    public CIPEncapsulationReadResponseBuilder(DF1ResponseMessage response, Integer packetLen) {

      this.response = response;
      this.packetLen = packetLen;
    }

    public CIPEncapsulationReadResponse build(
        long sessionHandle, long status, List<Short> senderContext, long options) {
      CIPEncapsulationReadResponse cIPEncapsulationReadResponse =
          new CIPEncapsulationReadResponse(
              sessionHandle, status, senderContext, options, response, packetLen);
      return cIPEncapsulationReadResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CIPEncapsulationReadResponse)) {
      return false;
    }
    CIPEncapsulationReadResponse that = (CIPEncapsulationReadResponse) o;
    return (getResponse() == that.getResponse()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getResponse());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
