/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.protocol;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.abeth.configuration.AbEthConfiguration;
import org.apache.plc4x.java.abeth.field.AbEthField;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionResponse;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadResponse;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandRequestMessage;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandResponseMessageProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestProtectedTypedLogicalRead;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbEthProtocolLogic
extends Plc4xProtocolBase<CIPEncapsulationPacket>
implements HasConfiguration<AbEthConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(AbEthProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private static final List<Short> emptySenderContext = Arrays.asList((short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0);
    private AbEthConfiguration configuration;
    private final AtomicInteger transactionCounterGenerator = new AtomicInteger(10);
    private RequestTransactionManager tm;
    private long sessionHandle;

    public void setConfiguration(AbEthConfiguration configuration) {
        this.configuration = configuration;
        this.tm = new RequestTransactionManager(1);
    }

    public void onConnect(ConversationContext<CIPEncapsulationPacket> context) {
        logger.debug("Sending COTP Connection Request");
        CIPEncapsulationConnectionRequest connectionRequest = new CIPEncapsulationConnectionRequest(0L, 0L, emptySenderContext, 0L);
        context.sendRequest((Object)connectionRequest).expectResponse(CIPEncapsulationPacket.class, REQUEST_TIMEOUT).check(p -> p instanceof CIPEncapsulationConnectionResponse).unwrap(p -> (CIPEncapsulationConnectionResponse)p).handle(cipEncapsulationConnectionResponse -> {
            this.sessionHandle = cipEncapsulationConnectionResponse.getSessionHandle();
            context.fireConnected();
        });
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        Iterator iterator = readRequest.getFieldNames().iterator();
        if (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            PlcField field = readRequest.getField(fieldName);
            if (!(field instanceof AbEthField)) {
                logger.error("The field should have been of type AbEthField");
            }
            AbEthField abEthField = (AbEthField)field;
            DF1RequestProtectedTypedLogicalRead logicalRead = new DF1RequestProtectedTypedLogicalRead(abEthField.getByteSize(), abEthField.getFileNumber(), abEthField.getFileType().getTypeCode(), abEthField.getElementNumber(), 0);
            int transactionCounter = this.transactionCounterGenerator.incrementAndGet();
            if (this.transactionCounterGenerator.get() == 65535) {
                this.transactionCounterGenerator.set(1);
            }
            DF1CommandRequestMessage requestMessage = new DF1CommandRequestMessage((short)this.configuration.getStation(), 5, 0, transactionCounter, logicalRead);
            CIPEncapsulationReadRequest read = new CIPEncapsulationReadRequest(this.sessionHandle, 0L, emptySenderContext, 0L, requestMessage);
            CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)read).expectResponse(CIPEncapsulationPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p instanceof CIPEncapsulationReadResponse).unwrap(p -> (CIPEncapsulationReadResponse)p).check(p -> p.getResponse().getTransactionCounter() == transactionCounter).handle(p -> {
                PlcResponse response = this.decodeReadResponse((CIPEncapsulationReadResponse)p, readRequest);
                transaction.endRequest();
            }));
            return future;
        }
        return null;
    }

    public void close(ConversationContext<CIPEncapsulationPacket> context) {
    }

    private PlcResponse decodeReadResponse(CIPEncapsulationReadResponse plcReadResponse, PlcReadRequest plcReadRequest) {
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        for (String fieldName : plcReadRequest.getFieldNames()) {
            AbEthField field = (AbEthField)plcReadRequest.getField(fieldName);
            PlcResponseCode responseCode = this.decodeResponseCode(plcReadResponse.getResponse().getStatus());
            PlcValue plcValue = null;
            if (responseCode == PlcResponseCode.OK) {
                try {
                    switch (field.getFileType()) {
                        case INTEGER: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if (data.size() == 1) {
                                    plcValue = new PlcINT(data.get(0));
                                    break;
                                }
                                plcValue = IEC61131ValueHandler.of(data);
                            }
                            break;
                        }
                        case WORD: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if ((data.get(1) >> 7 & 1) == 0) {
                                    plcValue = IEC61131ValueHandler.of((Object)((data.get(1) << 8) + data.get(0)));
                                    break;
                                }
                                plcValue = IEC61131ValueHandler.of((Object)((((~data.get(1).shortValue() & 0x7F) << 8) + (~(data.get(0) - 1) & 0xFF)) * -1));
                            }
                            break;
                        }
                        case DWORD: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if ((data.get(3) >> 7 & 1) == 0) {
                                    plcValue = IEC61131ValueHandler.of((Object)((data.get(3) << 24) + (data.get(2) << 16) + (data.get(1) << 8) + data.get(0)));
                                    break;
                                }
                                plcValue = IEC61131ValueHandler.of((Object)((((~data.get(3).shortValue() & 0x7F) << 24) + ((~(data.get(2) - 1) & 0xFF) << 16) + ((~(data.get(1) - 1) & 0xFF) << 8) + (~(data.get(0) - 1) & 0xFF)) * -1));
                            }
                            break;
                        }
                        case SINGLEBIT: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if (field.getBitNumber() < 8) {
                                    plcValue = IEC61131ValueHandler.of((Object)((data.get(0) & 1 << field.getBitNumber()) != 0 ? 1 : 0));
                                    break;
                                }
                                plcValue = IEC61131ValueHandler.of((Object)((data.get(1) & 1 << field.getBitNumber() - 8) != 0 ? 1 : 0));
                            }
                            break;
                        }
                        default: {
                            logger.warn("Problem during decoding of field {}: Decoding of file type not implemented; FieldInformation: {}", (Object)fieldName, (Object)field);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Some other error occurred casting field {}, FieldInformation: {}", new Object[]{fieldName, field, e});
                }
            }
            ResponseItem result = new ResponseItem(responseCode, plcValue);
            values.put(fieldName, result);
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponseCode decodeResponseCode(short status) {
        if (status == 0) {
            return PlcResponseCode.OK;
        }
        return PlcResponseCode.NOT_FOUND;
    }
}

