/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.tag;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.abeth.types.FileType;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;

public class AbEthTag
implements PlcTag {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^N(?<fileNumber>\\d{1,7}):(?<elementNumber>\\d{1,7})(/(?<bitNumber>\\d{1,7}))?:(?<dataType>[a-zA-Z_]+)(\\[(?<size>\\d+)])?");
    private static final String FILE_NUMBER = "fileNumber";
    private static final String ELEMENT_NUMBER = "elementNumber";
    private static final String BIT_NUMBER = "bitNumber";
    private static final String DATA_TYPE = "dataType";
    private static final String SIZE = "size";
    private final short byteSize;
    private final short fileNumber;
    private final FileType fileType;
    private final short elementNumber;
    private final short bitNumber;

    public AbEthTag(short byteSize, short fileNumber, FileType fileType, short elementNumber, short bitNumber) {
        this.byteSize = byteSize;
        this.fileNumber = fileNumber;
        this.fileType = fileType;
        this.elementNumber = elementNumber;
        this.bitNumber = bitNumber;
    }

    public short getByteSize() {
        return this.byteSize;
    }

    public short getFileNumber() {
        return this.fileNumber;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String getAddressString() {
        String address = String.format("N%d:%d", this.fileNumber, this.elementNumber);
        if (this.bitNumber != 0) {
            address = String.valueOf(address) + "/" + this.bitNumber;
        }
        address = String.valueOf(address) + ":" + this.fileType.name();
        if (this.byteSize != 1) {
            address = String.valueOf(address) + "[" + this.byteSize + "]";
        }
        return address;
    }

    public PlcValueType getPlcValueType() {
        return this.fileType.getPlcValueType();
    }

    public List<ArrayInfo> getArrayInfo() {
        return super.getArrayInfo();
    }

    public short getElementNumber() {
        return this.elementNumber;
    }

    public short getBitNumber() {
        return this.bitNumber;
    }

    public static boolean matches(String fieldString) {
        return ADDRESS_PATTERN.matcher(fieldString).matches();
    }

    public static AbEthTag of(String fieldString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            short byteSize;
            short fileNumber = Short.parseShort(matcher.group(FILE_NUMBER));
            short elementNumber = Short.parseShort(matcher.group(ELEMENT_NUMBER));
            short bitNumber = matcher.group(BIT_NUMBER) != null ? Short.parseShort(matcher.group(BIT_NUMBER)) : (short)0;
            FileType fileType = FileType.valueOf(matcher.group(DATA_TYPE).toUpperCase());
            switch (fileType) {
                case WORD: 
                case SINGLEBIT: {
                    byteSize = 2;
                    break;
                }
                case DWORD: {
                    byteSize = 4;
                    break;
                }
                default: {
                    byteSize = Short.parseShort(matcher.group(SIZE));
                }
            }
            return new AbEthTag(byteSize, fileNumber, fileType, elementNumber, bitNumber);
        }
        throw new PlcInvalidTagException("Unable to parse tag address: " + fieldString);
    }
}

