/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.ads.configuration.AdsConfiguration;
import org.apache.plc4x.java.ads.discovery.AdsPlcDiscoverer;
import org.apache.plc4x.java.ads.protocol.AdsProtocolLogic;
import org.apache.plc4x.java.ads.readwrite.AmsTCPPacket;
import org.apache.plc4x.java.ads.tag.AdsTagHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.metadata.PlcDriverMetadata;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryRequest;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;

public class AdsPlcDriver
extends GeneratedDriverBase<AmsTCPPacket> {
    public String getProtocolCode() {
        return "ads";
    }

    public String getProtocolName() {
        return "Beckhoff TwinCat ADS";
    }

    public PlcDiscoveryRequest.Builder discoveryRequestBuilder() {
        return new DefaultPlcDiscoveryRequest.Builder((PlcDiscoverer)new AdsPlcDiscoverer());
    }

    protected boolean canPing() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected boolean canBrowse() {
        return true;
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return AdsConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected AdsTagHandler getTagHandler() {
        return new AdsTagHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new org.apache.plc4x.java.spi.values.PlcValueHandler();
    }

    public PlcDriverMetadata getMetadata() {
        return () -> true;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected ProtocolStackConfigurer<AmsTCPPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(AmsTCPPacket.class, (readBuffer, objectArray) -> AmsTCPPacket.staticParse(readBuffer, objectArray)).withPacketSizeEstimator(ByteLengthEstimator.class).withProtocol(AdsProtocolLogic.class).littleEndian().build();
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return (int)byteBuf.getUnsignedIntLE(byteBuf.readerIndex() + 2) + 6;
            }
            return -1;
        }
    }
}

