/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.CommandId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AdsReadRequest
extends AmsPacket
implements Message {
    protected final long indexGroup;
    protected final long indexOffset;
    protected final long length;

    @Override
    public CommandId getCommandId() {
        return CommandId.ADS_READ;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public AdsReadRequest(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId, long indexGroup, long indexOffset, long length) {
        super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
        this.indexGroup = indexGroup;
        this.indexOffset = indexOffset;
        this.length = length;
    }

    public long getIndexGroup() {
        return this.indexGroup;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsReadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"indexGroup", (Object)this.indexGroup, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"indexOffset", (Object)this.indexOffset, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"length", (Object)this.length, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AdsReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsReadRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static AmsPacket.AmsPacketBuilder staticParseAmsPacketBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long indexGroup = (Long)FieldReaderFactory.readSimpleField((String)"indexGroup", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long indexOffset = (Long)FieldReaderFactory.readSimpleField((String)"indexOffset", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long length = (Long)FieldReaderFactory.readSimpleField((String)"length", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("AdsReadRequest", new WithReaderArgs[0]);
        return new AdsReadRequestBuilderImpl(indexGroup, indexOffset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsReadRequest)) {
            return false;
        }
        AdsReadRequest that = (AdsReadRequest)o;
        return this.getIndexGroup() == that.getIndexGroup() && this.getIndexOffset() == that.getIndexOffset() && this.getLength() == that.getLength() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getIndexGroup(), this.getIndexOffset(), this.getLength());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsReadRequestBuilderImpl
    implements AmsPacket.AmsPacketBuilder {
        private final long indexGroup;
        private final long indexOffset;
        private final long length;

        public AdsReadRequestBuilderImpl(long indexGroup, long indexOffset, long length) {
            this.indexGroup = indexGroup;
            this.indexOffset = indexOffset;
            this.length = length;
        }

        @Override
        public AdsReadRequest build(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId) {
            AdsReadRequest adsReadRequest = new AdsReadRequest(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId, this.indexGroup, this.indexOffset, this.length);
            return adsReadRequest;
        }
    }
}

