/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetBDTEntry implements Message {

  // Properties.
  protected final BACnetHostNPortEnclosed bbmdAddress;
  protected final BACnetContextTagOctetString broadcastMask;

  public BACnetBDTEntry(
      BACnetHostNPortEnclosed bbmdAddress, BACnetContextTagOctetString broadcastMask) {
    super();
    this.bbmdAddress = bbmdAddress;
    this.broadcastMask = broadcastMask;
  }

  public BACnetHostNPortEnclosed getBbmdAddress() {
    return bbmdAddress;
  }

  public BACnetContextTagOctetString getBroadcastMask() {
    return broadcastMask;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetBDTEntry");

    // Simple Field (bbmdAddress)
    writeSimpleField("bbmdAddress", bbmdAddress, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (broadcastMask) (Can be skipped, if the value is null)
    writeOptionalField("broadcastMask", broadcastMask, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetBDTEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetBDTEntry _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (bbmdAddress)
    lengthInBits += bbmdAddress.getLengthInBits();

    // Optional Field (broadcastMask)
    if (broadcastMask != null) {
      lengthInBits += broadcastMask.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetBDTEntry staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetBDTEntry staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetBDTEntry");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetHostNPortEnclosed bbmdAddress =
        readSimpleField(
            "bbmdAddress",
            new DataReaderComplexDefault<>(
                () -> BACnetHostNPortEnclosed.staticParse(readBuffer, (short) (0)), readBuffer));

    BACnetContextTagOctetString broadcastMask =
        readOptionalField(
            "broadcastMask",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagOctetString)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.OCTET_STRING)),
                readBuffer));

    readBuffer.closeContext("BACnetBDTEntry");
    // Create the instance
    BACnetBDTEntry _bACnetBDTEntry;
    _bACnetBDTEntry = new BACnetBDTEntry(bbmdAddress, broadcastMask);
    return _bACnetBDTEntry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetBDTEntry)) {
      return false;
    }
    BACnetBDTEntry that = (BACnetBDTEntry) o;
    return (getBbmdAddress() == that.getBbmdAddress())
        && (getBroadcastMask() == that.getBroadcastMask())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getBbmdAddress(), getBroadcastMask());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
