/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class BACnetConstructedData implements Message {

  // Abstract accessors for discriminator values.
  public abstract BACnetObjectType getObjectTypeArgument();

  public abstract BACnetPropertyIdentifier getPropertyIdentifierArgument();

  // Properties.
  protected final BACnetOpeningTag openingTag;
  protected final BACnetTagHeader peekedTagHeader;
  protected final BACnetClosingTag closingTag;

  // Arguments.
  protected final Short tagNumber;
  protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

  public BACnetConstructedData(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      Short tagNumber,
      BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
    super();
    this.openingTag = openingTag;
    this.peekedTagHeader = peekedTagHeader;
    this.closingTag = closingTag;
    this.tagNumber = tagNumber;
    this.arrayIndexArgument = arrayIndexArgument;
  }

  public BACnetOpeningTag getOpeningTag() {
    return openingTag;
  }

  public BACnetTagHeader getPeekedTagHeader() {
    return peekedTagHeader;
  }

  public BACnetClosingTag getClosingTag() {
    return closingTag;
  }

  public short getPeekedTagNumber() {
    return (short) (getPeekedTagHeader().getActualTagNumber());
  }

  protected abstract void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConstructedData");

    // Simple Field (openingTag)
    writeSimpleField("openingTag", openingTag, new DataWriterComplexDefault<>(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short peekedTagNumber = getPeekedTagNumber();
    writeBuffer.writeVirtual("peekedTagNumber", peekedTagNumber);

    // Switch field (Serialize the sub-type)
    serializeBACnetConstructedDataChild(writeBuffer);

    // Simple Field (closingTag)
    writeSimpleField("closingTag", closingTag, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetConstructedData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetConstructedData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (openingTag)
    lengthInBits += openingTag.getLengthInBits();

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    // Simple field (closingTag)
    lengthInBits += closingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetConstructedData staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 4)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 4, but got " + args.length);
    }
    Short tagNumber;
    if (args[0] instanceof Short) {
      tagNumber = (Short) args[0];
    } else if (args[0] instanceof String) {
      tagNumber = Short.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Short or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    BACnetObjectType objectTypeArgument;
    if (args[1] instanceof BACnetObjectType) {
      objectTypeArgument = (BACnetObjectType) args[1];
    } else if (args[1] instanceof String) {
      objectTypeArgument = BACnetObjectType.valueOf((String) args[1]);
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type BACnetObjectType or a string which is parseable but"
              + " was "
              + args[1].getClass().getName());
    }
    BACnetPropertyIdentifier propertyIdentifierArgument;
    if (args[2] instanceof BACnetPropertyIdentifier) {
      propertyIdentifierArgument = (BACnetPropertyIdentifier) args[2];
    } else if (args[2] instanceof String) {
      propertyIdentifierArgument = BACnetPropertyIdentifier.valueOf((String) args[2]);
    } else {
      throw new PlcRuntimeException(
          "Argument 2 expected to be of type BACnetPropertyIdentifier or a string which is"
              + " parseable but was "
              + args[2].getClass().getName());
    }
    BACnetTagPayloadUnsignedInteger arrayIndexArgument;
    if (args[3] instanceof BACnetTagPayloadUnsignedInteger) {
      arrayIndexArgument = (BACnetTagPayloadUnsignedInteger) args[3];
    } else {
      throw new PlcRuntimeException(
          "Argument 3 expected to be of type BACnetTagPayloadUnsignedInteger or a string which is"
              + " parseable but was "
              + args[3].getClass().getName());
    }
    return staticParse(
        readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument);
  }

  public static BACnetConstructedData staticParse(
      ReadBuffer readBuffer,
      Short tagNumber,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger arrayIndexArgument)
      throws ParseException {
    readBuffer.pullContext("BACnetConstructedData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag openingTag =
        readSimpleField(
            "openingTag",
            new DataReaderComplexDefault<>(
                () -> BACnetOpeningTag.staticParse(readBuffer, (short) (tagNumber)), readBuffer));

    BACnetTagHeader peekedTagHeader =
        readPeekField(
            "peekedTagHeader",
            new DataReaderComplexDefault<>(
                () -> BACnetTagHeader.staticParse(readBuffer), readBuffer));
    short peekedTagNumber =
        readVirtualField("peekedTagNumber", short.class, peekedTagHeader.getActualTagNumber());

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    BACnetConstructedDataBuilder builder = null;
    if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ABSENTEE_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAbsenteeLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCEPTED_MODES)) {
      builder =
          BACnetConstructedDataAcceptedModes.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_ALARM_EVENTS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAccessAlarmEvents.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_DOORS)) {
      builder =
          BACnetConstructedDataAccessDoors.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_EVENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAccessEvent.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.ACCESS_EVENT_AUTHENTICATION_FACTOR)) {
      builder =
          BACnetConstructedDataAccessEventAuthenticationFactor
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_EVENT_CREDENTIAL)) {
      builder =
          BACnetConstructedDataAccessEventCredential.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_EVENT_TAG)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccessEventTag.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_EVENT_TIME)) {
      builder =
          BACnetConstructedDataAccessEventTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCESS_TRANSACTION_EVENTS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAccessTransactionEvents.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCOMPANIMENT)) {
      builder =
          BACnetConstructedDataAccompaniment.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACCOMPANIMENT_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccompanimentTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACK_REQUIRED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAckRequired.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACKED_TRANSITIONS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAckedTransitions.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LOOP)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ACTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLoopAction.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.COMMAND)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ACTION)) {
      builder =
          BACnetConstructedDataCommandAction.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ACTION)) {
      builder =
          BACnetConstructedDataAction.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ACTION_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataActionText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACTIVATION_TIME)) {
      builder =
          BACnetConstructedDataActivationTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACTIVE_AUTHENTICATION_POLICY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataActiveAuthenticationPolicy.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS)) {
      builder =
          BACnetConstructedDataActiveCOVMultipleSubscriptions
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACTIVE_COV_SUBSCRIPTIONS)) {
      builder =
          BACnetConstructedDataActiveCOVSubscriptions.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ACTIVE_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataActiveText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACTIVE_VT_SESSIONS)) {
      builder =
          BACnetConstructedDataActiveVTSessions.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ACTUAL_SHED_LEVEL)) {
      builder =
          BACnetConstructedDataActualShedLevel.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_ZONE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ADJUST_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataAccessZoneAdjustValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.PULSE_CONVERTER)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ADJUST_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataPulseConverterAdjustValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ADJUST_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataAdjustValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAlarmValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_DOOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataAccessDoorAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_ZONE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataAccessZoneAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BITSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataBitStringValueAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHARACTERSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataCharacterStringValueAlarmValues
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_POINT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataLifeSafetyPointAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_ZONE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataLifeSafetyZoneAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateInputAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateValueAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMER)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataTimerAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALARM_VALUES)) {
      builder =
          BACnetConstructedDataAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALIGN_INTERVALS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataAlignIntervals.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_CREDENTIAL)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccessCredentialAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_DOOR)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccessDoorAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_POINT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccessPointAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_RIGHTS)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccessRightsAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_USER)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccessUserAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_ZONE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccessZoneAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAccumulatorAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ALERT_ENROLLMENT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAlertEnrollmentAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_INPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAnalogInputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_OUTPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAnalogOutputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAnalogValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.AVERAGING)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataAveragingAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_INPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataBinaryInputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_LIGHTING_OUTPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataBinaryLightingOutputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_OUTPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataBinaryOutputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataBinaryValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BITSTRING_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataBitstringValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CALENDAR)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataCalendarAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHANNEL)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataChannelAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHARACTERSTRING_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataCharacterstringValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.COMMAND)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataCommandAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CREDENTIAL_DATA_INPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataCredentialDataInputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATEPATTERN_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataDatepatternValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATE_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataDateValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATETIMEPATTERN_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataDatetimepatternValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATETIME_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataDatetimeValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DEVICE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataDeviceAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ELEVATOR_GROUP)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataElevatorGroupAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ESCALATOR)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataEscalatorAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.EVENT_ENROLLMENT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataEventEnrollmentAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.EVENT_LOG)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataEventLogAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.FILE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataFileAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.GLOBAL_GROUP)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataGlobalGroupAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.GROUP)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataGroupAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataIntegerValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLargeAnalogValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_POINT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLifeSafetyPointAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_ZONE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLifeSafetyZoneAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLiftAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIGHTING_OUTPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLightingOutputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LOAD_CONTROL)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLoadControlAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LOOP)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataLoopAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_INPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataMultiStateInputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_OUTPUT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataMultiStateOutputAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataMultiStateValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.NETWORK_PORT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataNetworkPortAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.NETWORK_SECURITY)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataNetworkSecurityAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.NOTIFICATION_CLASS)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataNotificationClassAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.NOTIFICATION_FORWARDER)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataNotificationForwarderAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.OCTETSTRING_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataOctetstringValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.PROGRAM)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataProgramAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.PULSE_CONVERTER)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataPulseConverterAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.SCHEDULE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataScheduleAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.STRUCTURED_VIEW)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataStructuredViewAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMEPATTERN_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataTimepatternValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIME_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataTimeValueAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMER)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataTimerAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TREND_LOG)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataTrendLogAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TREND_LOG_MULTIPLE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ALL)) {
      builder =
          BACnetConstructedDataTrendLogMultipleAll.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALL_WRITES_SUCCESSFUL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataAllWritesSuccessful.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ALLOW_GROUP_DELAY_INHIBIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataAllowGroupDelayInhibit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.APDU_LENGTH)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAPDULength.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.APDU_SEGMENT_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAPDUSegmentTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.APDU_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAPDUTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.APPLICATION_SOFTWARE_VERSION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataApplicationSoftwareVersion.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ARCHIVE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataArchive.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ASSIGNED_ACCESS_RIGHTS)) {
      builder =
          BACnetConstructedDataAssignedAccessRights.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ASSIGNED_LANDING_CALLS)) {
      builder =
          BACnetConstructedDataAssignedLandingCalls.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ATTEMPTED_SAMPLES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAttemptedSamples.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTHENTICATION_FACTORS)) {
      builder =
          BACnetConstructedDataAuthenticationFactors.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTHENTICATION_POLICY_LIST)) {
      builder =
          BACnetConstructedDataAuthenticationPolicyList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTHENTICATION_POLICY_NAMES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataAuthenticationPolicyNames.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTHENTICATION_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAuthenticationStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTHORIZATION_EXEMPTIONS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAuthorizationExemptions.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTHORIZATION_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAuthorizationMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AUTO_SLAVE_DISCOVERY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataAutoSlaveDiscovery.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.AVERAGE_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAverageValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACKUP_AND_RESTORE_STATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBackupAndRestoreState.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACKUP_FAILURE_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataBackupFailureTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACKUP_PREPARATION_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataBackupPreparationTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IP_GLOBAL_ADDRESS)) {
      builder =
          BACnetConstructedDataBACnetIPGlobalAddress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IP_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBACnetIPMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IP_MULTICAST_ADDRESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataBACnetIPMulticastAddress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IP_NAT_TRAVERSAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataBACnetIPNATTraversal.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IP_UDP_PORT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataBACnetIPUDPPort.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IPV6_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBACnetIPv6Mode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IPV6_UDP_PORT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataBACnetIPv6UDPPort.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BACNET_IPV6_MULTICAST_ADDRESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataBACnetIPv6MulticastAddress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BASE_DEVICE_SECURITY_POLICY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBaseDeviceSecurityPolicy.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BBMD_ACCEPT_FD_REGISTRATIONS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataBBMDAcceptFDRegistrations.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.BBMD_BROADCAST_DISTRIBUTION_TABLE)) {
      builder =
          BACnetConstructedDataBBMDBroadcastDistributionTable
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BBMD_FOREIGN_DEVICE_TABLE)) {
      builder =
          BACnetConstructedDataBBMDForeignDeviceTable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BELONGS_TO)) {
      builder =
          BACnetConstructedDataBelongsTo.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.BIAS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataBias.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.BIT_MASK)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataBitMask.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.BIT_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataBitText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.BLINK_WARN_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataBlinkWarnEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.BUFFER_SIZE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataBufferSize.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_ASSIGNED_DIRECTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarAssignedDirection.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_DOOR_COMMAND)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarDoorCommand.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_DOOR_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarDoorStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_DOOR_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataCarDoorText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_DOOR_ZONE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataCarDoorZone.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_DRIVE_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarDriveStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_LOAD)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataCarLoad.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_LOAD_UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarLoadUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_MOVING_DIRECTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCarMovingDirection.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CAR_POSITION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataCarPosition.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CHANGE_OF_STATE_COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataChangeOfStateCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CHANGE_OF_STATE_TIME)) {
      builder =
          BACnetConstructedDataChangeOfStateTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CHANGES_PENDING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataChangesPending.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CHANNEL_NUMBER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataChannelNumber.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CLIENT_COV_INCREMENT)) {
      builder =
          BACnetConstructedDataClientCOVIncrement.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.COMMAND)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCommand.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COMMAND_TIME_ARRAY)) {
      builder =
          BACnetConstructedDataCommandTimeArray.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CONFIGURATION_FILES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataConfigurationFiles.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CONTROL_GROUPS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataControlGroups.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CONTROLLED_VARIABLE_REFERENCE)) {
      builder =
          BACnetConstructedDataControlledVariableReference.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CONTROLLED_VARIABLE_UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataControlledVariableUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CONTROLLED_VARIABLE_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataControlledVariableValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COUNT_BEFORE_CHANGE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataCountBeforeChange.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COUNT_CHANGE_TIME)) {
      builder =
          BACnetConstructedDataCountChangeTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COV_INCREMENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIntegerValueCOVIncrement.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COV_INCREMENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueCOVIncrement.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COV_INCREMENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueCOVIncrement
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COV_INCREMENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataCOVIncrement.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.COV_PERIOD)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataCOVPeriod.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COV_RESUBSCRIPTION_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataCOVResubscriptionInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.COVU_PERIOD)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataCOVUPeriod.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.COVU_RECIPIENTS)) {
      builder =
          BACnetConstructedDataCOVURecipients.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CREDENTIAL_DISABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCredentialDisable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CREDENTIAL_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataCredentialStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CREDENTIALS)) {
      builder =
          BACnetConstructedDataCredentials.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CREDENTIALS_IN_ZONE)) {
      builder =
          BACnetConstructedDataCredentialsInZone.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.CURRENT_COMMAND_PRIORITY)) {
      builder =
          BACnetConstructedDataCurrentCommandPriority.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DATABASE_REVISION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDatabaseRevision.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DATE_LIST)) {
      builder =
          BACnetConstructedDataDateList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DAYLIGHT_SAVINGS_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataDaylightSavingsStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DAYS_REMAINING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataDaysRemaining.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DEADBAND)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIntegerValueDeadband.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DEADBAND)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueDeadband.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DEADBAND)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueDeadband.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DEADBAND)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataDeadband.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEFAULT_FADE_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDefaultFadeTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEFAULT_RAMP_RATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataDefaultRampRate.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEFAULT_STEP_INCREMENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataDefaultStepIncrement.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEFAULT_SUBORDINATE_RELATIONSHIP)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataDefaultSubordinateRelationship
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEFAULT_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDefaultTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEPLOYED_PROFILE_LOCATION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataDeployedProfileLocation.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DERIVATIVE_CONSTANT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataDerivativeConstant.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DERIVATIVE_CONSTANT_UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataDerivativeConstantUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DESCRIPTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataDescription.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DESCRIPTION_OF_HALT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataDescriptionOfHalt.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DEVICE_ADDRESS_BINDING)) {
      builder =
          BACnetConstructedDataDeviceAddressBinding.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DEVICE_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataDeviceType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DIRECT_READING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataDirectReading.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DISTRIBUTION_KEY_REVISION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDistributionKeyRevision.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DO_NOT_HIDE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataDoNotHide.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_ALARM_STATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataDoorAlarmState.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_EXTENDED_PULSE_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDoorExtendedPulseTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_MEMBERS)) {
      builder =
          BACnetConstructedDataDoorMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_OPEN_TOO_LONG_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDoorOpenTooLongTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_PULSE_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDoorPulseTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataDoorStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.DOOR_UNLOCK_DELAY_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDoorUnlockDelayTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.DUTY_WINDOW)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDutyWindow.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EFFECTIVE_PERIOD)) {
      builder =
          BACnetConstructedDataEffectivePeriod.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EGRESS_ACTIVE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataEgressActive.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.EGRESS_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataEgressTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ELAPSED_ACTIVE_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataElapsedActiveTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ELEVATOR_GROUP)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataElevatorGroup.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ENERGY_METER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataEnergyMeter.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ENERGY_METER_REF)) {
      builder =
          BACnetConstructedDataEnergyMeterRef.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ENTRY_POINTS)) {
      builder =
          BACnetConstructedDataEntryPoints.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ERROR_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataErrorLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ESCALATOR_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataEscalatorMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_ALGORITHM_INHIBIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataEventAlgorithmInhibit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_ALGORITHM_INHIBIT_REF)) {
      builder =
          BACnetConstructedDataEventAlgorithmInhibitRef.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_DETECTION_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataEventDetectionEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataEventEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_MESSAGE_TEXTS)) {
      builder =
          BACnetConstructedDataEventMessageTexts.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_MESSAGE_TEXTS_CONFIG)) {
      builder =
          BACnetConstructedDataEventMessageTextsConfig.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_PARAMETERS)) {
      builder =
          BACnetConstructedDataEventParameters.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_STATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataEventState.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_TIME_STAMPS)) {
      builder =
          BACnetConstructedDataEventTimeStamps.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.EVENT_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataEventType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EXCEPTION_SCHEDULE)) {
      builder =
          BACnetConstructedDataExceptionSchedule.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EXECUTION_DELAY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataExecutionDelay.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EXIT_POINTS)) {
      builder =
          BACnetConstructedDataExitPoints.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EXPECTED_SHED_LEVEL)) {
      builder =
          BACnetConstructedDataExpectedShedLevel.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EXPIRATION_TIME)) {
      builder =
          BACnetConstructedDataExpirationTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.EXTENDED_TIME_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataExtendedTimeEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAILED_ATTEMPT_EVENTS)) {
      builder =
          BACnetConstructedDataFailedAttemptEvents.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAILED_ATTEMPTS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataFailedAttempts.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAILED_ATTEMPTS_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataFailedAttemptsTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccumulatorFaultHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogInputFaultHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogValueFaultHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueFaultHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueFaultHighLimit
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueFaultHighLimit
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataFaultHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccumulatorFaultLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogInputFaultLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogValueFaultLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueFaultLowLimit
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueFaultLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueFaultLowLimit
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataFaultLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_PARAMETERS)) {
      builder =
          BACnetConstructedDataFaultParameters.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ESCALATOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_SIGNALS)) {
      builder =
          BACnetConstructedDataEscalatorFaultSignals.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_SIGNALS)) {
      builder =
          BACnetConstructedDataLiftFaultSignals.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_SIGNALS)) {
      builder =
          BACnetConstructedDataFaultSignals.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataFaultType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_DOOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)) {
      builder =
          BACnetConstructedDataAccessDoorFaultValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHARACTERSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)) {
      builder =
          BACnetConstructedDataCharacterStringValueFaultValues
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_POINT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)) {
      builder =
          BACnetConstructedDataLifeSafetyPointFaultValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_ZONE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)) {
      builder =
          BACnetConstructedDataLifeSafetyZoneFaultValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateInputFaultValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateValueFaultValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FAULT_VALUES)) {
      builder =
          BACnetConstructedDataFaultValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FD_BBMD_ADDRESS)) {
      builder =
          BACnetConstructedDataFDBBMDAddress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FD_SUBSCRIPTION_LIFETIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataFDSubscriptionLifetime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FEEDBACK_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryLightingOutputFeedbackValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FEEDBACK_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryOutputFeedbackValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FEEDBACK_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLightingOutputFeedbackValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FEEDBACK_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateOutputFeedbackValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FILE_ACCESS_METHOD)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataFileAccessMethod.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.FILE_SIZE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataFileSize.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.FILE_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataFileType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FIRMWARE_REVISION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataFirmwareRevision.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.FLOOR_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataFloorText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.FULL_DUTY_BASELINE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataFullDutyBaseline.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.GLOBAL_IDENTIFIER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataGlobalIdentifier.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.GROUP_ID)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataGroupID.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.GROUP_MEMBER_NAMES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataGroupMemberNames.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.GLOBAL_GROUP)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.GROUP_MEMBERS)) {
      builder =
          BACnetConstructedDataGlobalGroupGroupMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ELEVATOR_GROUP)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.GROUP_MEMBERS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataElevatorGroupGroupMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.GROUP_MEMBERS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataGroupMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.GROUP_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataGroupMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccumulatorHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueHighLimit
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.HIGH_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataHighLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.HIGHER_DECK)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataHigherDeck.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.IN_PROCESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataInProcess.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.IN_PROGRESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataInProgress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INACTIVE_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataInactiveText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INITIAL_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataInitialTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INPUT_REFERENCE)) {
      builder =
          BACnetConstructedDataInputReference.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INSTALLATION_ID)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataInstallationID.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.INSTANCE_OF)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataInstanceOf.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INSTANTANEOUS_POWER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataInstantaneousPower.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTEGRAL_CONSTANT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataIntegralConstant.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTEGRAL_CONSTANT_UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataIntegralConstantUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERFACE_VALUE)) {
      builder =
          BACnetConstructedDataAnalogInputInterfaceValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERFACE_VALUE)) {
      builder =
          BACnetConstructedDataAnalogOutputInterfaceValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERFACE_VALUE)) {
      builder =
          BACnetConstructedDataBinaryInputInterfaceValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERFACE_VALUE)) {
      builder =
          BACnetConstructedDataBinaryOutputInterfaceValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERFACE_VALUE)) {
      builder =
          BACnetConstructedDataMultiStateInputInterfaceValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERFACE_VALUE)) {
      builder =
          BACnetConstructedDataMultiStateOutputInterfaceValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.INTERVAL_OFFSET)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIntervalOffset.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.IP_ADDRESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPAddress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_DEFAULT_GATEWAY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPDefaultGateway.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_DHCP_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataIPDHCPEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_DHCP_LEASE_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIPDHCPLeaseTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_DHCP_LEASE_TIME_REMAINING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIPDHCPLeaseTimeRemaining.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_DHCP_SERVER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPDHCPServer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_DNS_SERVER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPDNSServer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IP_SUBNET_MASK)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPSubnetMask.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_ADDRESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPv6Address.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_AUTO_ADDRESSING_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataIPv6AutoAddressingEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_DEFAULT_GATEWAY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPv6DefaultGateway.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_DHCP_LEASE_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIPv6DHCPLeaseTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_DHCP_LEASE_TIME_REMAINING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIPv6DHCPLeaseTimeRemaining.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_DHCP_SERVER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPv6DHCPServer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_DNS_SERVER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataIPv6DNSServer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_PREFIX_LENGTH)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataIPv6PrefixLength.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.IPV6_ZONE_INDEX)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataIPv6ZoneIndex.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.IS_UTC)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataIsUTC.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.KEY_SETS)) {
      builder =
          BACnetConstructedDataKeySets.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LANDING_CALL_CONTROL)) {
      builder =
          BACnetConstructedDataLandingCallControl.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LANDING_CALLS)) {
      builder =
          BACnetConstructedDataLandingCalls.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LANDING_DOOR_STATUS)) {
      builder =
          BACnetConstructedDataLandingDoorStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_ACCESS_EVENT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLastAccessEvent.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_ACCESS_POINT)) {
      builder =
          BACnetConstructedDataLastAccessPoint.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_COMMAND_TIME)) {
      builder =
          BACnetConstructedDataLastCommandTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_CREDENTIAL_ADDED)) {
      builder =
          BACnetConstructedDataLastCredentialAdded.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_CREDENTIAL_ADDED_TIME)) {
      builder =
          BACnetConstructedDataLastCredentialAddedTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_CREDENTIAL_REMOVED)) {
      builder =
          BACnetConstructedDataLastCredentialRemoved.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_CREDENTIAL_REMOVED_TIME)) {
      builder =
          BACnetConstructedDataLastCredentialRemovedTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_KEY_SERVER)) {
      builder =
          BACnetConstructedDataLastKeyServer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_NOTIFY_RECORD)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataLastNotifyRecord.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_PRIORITY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataLastPriority.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_RESTART_REASON)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLastRestartReason.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_RESTORE_TIME)) {
      builder =
          BACnetConstructedDataLastRestoreTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_STATE_CHANGE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLastStateChange.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LAST_USE_TIME)) {
      builder =
          BACnetConstructedDataLastUseTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LIFE_SAFETY_ALARM_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLifeSafetyAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LIGHTING_COMMAND)) {
      builder =
          BACnetConstructedDataLightingCommand.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LIGHTING_COMMAND_DEFAULT_PRIORITY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataLightingCommandDefaultPriority
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LIMIT_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataLimitEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LIMIT_MONITORING_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataLimitMonitoringInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LINK_SPEED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLinkSpeed.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LINK_SPEED_AUTONEGOTIATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataLinkSpeedAutonegotiate.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LINK_SPEEDS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLinkSpeeds.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LIST_OF_GROUP_MEMBERS)) {
      builder =
          BACnetConstructedDataListOfGroupMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHANNEL)
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.LIST_OF_OBJECT_PROPERTY_REFERENCES)) {
      builder =
          BACnetConstructedDataChannelListOfObjectPropertyReferences
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.LIST_OF_OBJECT_PROPERTY_REFERENCES)) {
      builder =
          BACnetConstructedDataListOfObjectPropertyReferences
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOCAL_DATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 10)) {
      builder =
          BACnetConstructedDataLocalDate.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOCAL_FORWARDING_ONLY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataLocalForwardingOnly.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOCAL_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataLocalTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOCATION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataLocation.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOCK_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLockStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOCKOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataLockout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOCKOUT_RELINQUISH_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataLockoutRelinquishTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.EVENT_LOG)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_BUFFER)) {
      builder =
          BACnetConstructedDataEventLogLogBuffer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TREND_LOG)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_BUFFER)) {
      builder =
          BACnetConstructedDataTrendLogLogBuffer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TREND_LOG_MULTIPLE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_BUFFER)) {
      builder =
          BACnetConstructedDataTrendLogMultipleLogBuffer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_BUFFER)) {
      builder =
          BACnetConstructedDataLogBuffer.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TREND_LOG)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY)) {
      builder =
          BACnetConstructedDataTrendLogLogDeviceObjectProperty
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TREND_LOG_MULTIPLE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY)) {
      builder =
          BACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY)) {
      builder =
          BACnetConstructedDataLogDeviceObjectProperty.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOG_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataLogInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOGGING_OBJECT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataLoggingObject.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOGGING_RECORD)) {
      builder =
          BACnetConstructedDataLoggingRecord.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOGGING_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLoggingType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.LOW_DIFF_LIMIT)) {
      builder =
          BACnetConstructedDataLowDiffLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccumulatorLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOW_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLowLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.LOWER_DECK)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataLowerDeck.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MAC_ADDRESS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataMACAddress.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MACHINE_ROOM_ID)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataMachineRoomID.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_ZONE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAINTENANCE_REQUIRED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataLifeSafetyZoneMaintenanceRequired
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAINTENANCE_REQUIRED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataMaintenanceRequired.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAKING_CAR_CALL)) {
      builder =
          BACnetConstructedDataMakingCarCall.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MANIPULATED_VARIABLE_REFERENCE)) {
      builder =
          BACnetConstructedDataManipulatedVariableReference.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MANUAL_SLAVE_ADDRESS_BINDING)) {
      builder =
          BACnetConstructedDataManualSlaveAddressBinding.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MASKED_ALARM_VALUES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataMaskedAlarmValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_ACTUAL_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMaxActualValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_APDU_LENGTH_ACCEPTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMaxAPDULengthAccepted.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_FAILED_ATTEMPTS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMaxFailedAttempts.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DEVICE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_INFO_FRAMES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDeviceMaxInfoFrames.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.NETWORK_PORT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_INFO_FRAMES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNetworkPortMaxInfoFrames.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_INFO_FRAMES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMaxInfoFrames.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DEVICE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_MASTER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataDeviceMaxMaster.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.NETWORK_PORT)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_MASTER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNetworkPortMaxMaster.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_MASTER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMaxMaster.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccumulatorMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogInputMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogOutputMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogValueMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueMaxPresValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMER)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTimerMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMaxPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAX_SEGMENTS_ACCEPTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMaxSegmentsAccepted.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAXIMUM_OUTPUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMaximumOutput.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAXIMUM_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMaximumValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MAXIMUM_VALUE_TIMESTAMP)) {
      builder =
          BACnetConstructedDataMaximumValueTimestamp.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MEMBER_OF)) {
      builder =
          BACnetConstructedDataMemberOf.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MEMBER_STATUS_FLAGS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataMemberStatusFlags.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MEMBERS)) {
      builder =
          BACnetConstructedDataMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_ACTUAL_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMinActualValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCUMULATOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataAccumulatorMinPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueMinPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueMinPresValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueMinPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMER)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTimerMinPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MIN_PRES_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMinPresValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MINIMUM_OFF_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMinimumOffTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MINIMUM_ON_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMinimumOnTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MINIMUM_OUTPUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMinimumOutput.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MINIMUM_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataMinimumValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MINIMUM_VALUE_TIMESTAMP)) {
      builder =
          BACnetConstructedDataMinimumValueTimestamp.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.MODEL_NAME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataModelName.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MODIFICATION_DATE)) {
      builder =
          BACnetConstructedDataModificationDate.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.MUSTER_POINT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataMusterPoint.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NEGATIVE_ACCESS_RULES)) {
      builder =
          BACnetConstructedDataNegativeAccessRules.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.NETWORK_ACCESS_SECURITY_POLICIES)) {
      builder =
          BACnetConstructedDataNetworkAccessSecurityPolicies
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NETWORK_INTERFACE_NAME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataNetworkInterfaceName.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NETWORK_NUMBER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNetworkNumber.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NETWORK_NUMBER_QUALITY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataNetworkNumberQuality.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NETWORK_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataNetworkType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NEXT_STOPPING_FLOOR)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNextStoppingFloor.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NODE_SUBTYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataNodeSubtype.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.NODE_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataNodeType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NOTIFICATION_CLASS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNotificationClass.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NOTIFICATION_THRESHOLD)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNotificationThreshold.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.NOTIFY_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataNotifyType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NUMBER_OF_APDU_RETRIES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNumberOfAPDURetries.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NUMBER_OF_AUTHENTICATION_POLICIES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNumberOfAuthenticationPolicies
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.NUMBER_OF_STATES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataNumberOfStates.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OBJECT_IDENTIFIER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataObjectIdentifier.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OBJECT_LIST)) {
      builder =
          BACnetConstructedDataObjectList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.OBJECT_NAME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataObjectName.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OBJECT_PROPERTY_REFERENCE)) {
      builder =
          BACnetConstructedDataObjectPropertyReference.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.OBJECT_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataObjectType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataOccupancyCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_COUNT_ADJUST)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataOccupancyCountAdjust.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_COUNT_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataOccupancyCountEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_LOWER_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataOccupancyLowerLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_LOWER_LIMIT_ENFORCED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataOccupancyLowerLimitEnforced.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_STATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataOccupancyState.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_UPPER_LIMIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataOccupancyUpperLimit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OCCUPANCY_UPPER_LIMIT_ENFORCED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataOccupancyUpperLimitEnforced.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OPERATION_DIRECTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataOperationDirection.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OPERATION_EXPECTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataOperationExpected.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.OPTIONAL)) {
      builder =
          BACnetConstructedDataOptional.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OUT_OF_SERVICE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataOutOfService.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.OUTPUT_UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataOutputUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PACKET_REORDER_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPacketReorderTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PASSBACK_MODE)) {
      builder =
          BACnetConstructedDataPassbackMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PASSBACK_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPassbackTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PASSENGER_ALARM)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataPassengerAlarm.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.POLARITY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataPolarity.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PORT_FILTER)) {
      builder =
          BACnetConstructedDataPortFilter.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.POSITIVE_ACCESS_RULES)) {
      builder =
          BACnetConstructedDataPositiveAccessRules.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.POWER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataPower.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.POWER_MODE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataPowerMode.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.PRESCALE)) {
      builder =
          BACnetConstructedDataPrescale.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_DOOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAccessDoorPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ALERT_ENROLLMENT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 12)) {
      builder =
          BACnetConstructedDataAlertEnrollmentPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogInputPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogOutputPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryInputPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryOutputPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryLightingOutputPresentValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BITSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataBitStringValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CALENDAR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataCalendarPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHANNEL)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)) {
      builder =
          BACnetConstructedDataChannelPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHARACTERSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataCharacterStringValuePresentValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CREDENTIAL_DATA_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)) {
      builder =
          BACnetConstructedDataCredentialDataInputPresentValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATE_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 10)) {
      builder =
          BACnetConstructedDataDateValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATEPATTERN_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 10)) {
      builder =
          BACnetConstructedDataDatePatternValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATETIME_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataDateTimeValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATETIMEPATTERN_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataDateTimePatternValuePresentValue
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLightingOutputPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_POINT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLifeSafetyPointPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIFE_SAFETY_ZONE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLifeSafetyZonePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LOAD_CONTROL)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataLoadControlPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LOOP)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLoopPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.PULSE_CONVERTER)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataPulseConverterPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.GROUP)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)) {
      builder =
          BACnetConstructedDataGroupPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.GLOBAL_GROUP)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)) {
      builder =
          BACnetConstructedDataGlobalGroupPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.OCTETSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataOctetStringValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.SCHEDULE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)) {
      builder =
          BACnetConstructedDataSchedulePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIME_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataTimeValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMEPATTERN_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataTimePatternValuePresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRESENT_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPresentValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.PRIORITY)) {
      builder =
          BACnetConstructedDataPriority.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRIORITY_ARRAY)) {
      builder =
          BACnetConstructedDataPriorityArray.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PRIORITY_FOR_WRITING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPriorityForWriting.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROCESS_IDENTIFIER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataProcessIdentifier.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROCESS_IDENTIFIER_FILTER)) {
      builder =
          BACnetConstructedDataProcessIdentifierFilter.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROFILE_LOCATION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataProfileLocation.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROFILE_NAME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataProfileName.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROGRAM_CHANGE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataProgramChange.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROGRAM_LOCATION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataProgramLocation.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROGRAM_STATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataProgramState.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROPERTY_LIST)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataPropertyList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROPORTIONAL_CONSTANT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataProportionalConstant.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROPORTIONAL_CONSTANT_UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataProportionalConstantUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROTOCOL_LEVEL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataProtocolLevel.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROTOCOL_OBJECT_TYPES_SUPPORTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataProtocolObjectTypesSupported.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROTOCOL_REVISION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataProtocolRevision.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROTOCOL_SERVICES_SUPPORTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataProtocolServicesSupported.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.PROTOCOL_VERSION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataProtocolVersion.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.PULSE_RATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPulseRate.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.READ_ONLY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataReadOnly.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REASON_FOR_DISABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataReasonForDisable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REASON_FOR_HALT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataReasonForHalt.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RECIPIENT_LIST)) {
      builder =
          BACnetConstructedDataRecipientList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.FILE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RECORD_COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataFileRecordCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RECORD_COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataRecordCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RECORDS_SINCE_NOTIFICATION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataRecordsSinceNotification.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REFERENCE_PORT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataReferencePort.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REGISTERED_CAR_CALL)) {
      builder =
          BACnetConstructedDataRegisteredCarCall.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.RELIABILITY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataReliability.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELIABILITY_EVALUATION_INHIBIT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataReliabilityEvaluationInhibit.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ACCESS_DOOR)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataAccessDoorRelinquishDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogOutputRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataAnalogValueRelinquishDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryOutputRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryValueRelinquishDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BINARY_LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataBinaryLightingOutputRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.BITSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataBitStringValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CHARACTERSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataCharacterStringValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATE_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 10)) {
      builder =
          BACnetConstructedDataDateValueRelinquishDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATEPATTERN_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 10)) {
      builder =
          BACnetConstructedDataDatePatternValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATETIME_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)) {
      builder =
          BACnetConstructedDataDateTimeValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.DATETIMEPATTERN_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)) {
      builder =
          BACnetConstructedDataDateTimePatternValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLightingOutputRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMEPATTERN_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataTimePatternValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIME_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 11)) {
      builder =
          BACnetConstructedDataTimeValueRelinquishDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.OCTETSTRING_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 6)) {
      builder =
          BACnetConstructedDataOctetStringValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateOutputRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.MULTI_STATE_VALUE)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataMultiStateValueRelinquishDefault
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RELINQUISH_DEFAULT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataRelinquishDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REPRESENTS)) {
      builder =
          BACnetConstructedDataRepresents.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REQUESTED_SHED_LEVEL)) {
      builder =
          BACnetConstructedDataRequestedShedLevel.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.REQUESTED_UPDATE_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataRequestedUpdateInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.REQUIRED)) {
      builder =
          BACnetConstructedDataRequired.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LARGE_ANALOG_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.RESOLUTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetConstructedDataLargeAnalogValueResolution.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.RESOLUTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataIntegerValueResolution.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.POSITIVE_INTEGER_VALUE)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.RESOLUTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataPositiveIntegerValueResolution
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.TIMER)
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.RESOLUTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTimerResolution.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.RESOLUTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataResolution.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RESTART_NOTIFICATION_RECIPIENTS)) {
      builder =
          BACnetConstructedDataRestartNotificationRecipients
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RESTORE_COMPLETION_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataRestoreCompletionTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.RESTORE_PREPARATION_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataRestorePreparationTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ROUTING_TABLE)) {
      builder =
          BACnetConstructedDataRoutingTable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.SCALE)) {
      builder =
          BACnetConstructedDataScale.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SCALE_FACTOR)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataScaleFactor.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SCHEDULE_DEFAULT)) {
      builder =
          BACnetConstructedDataScheduleDefault.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SECURED_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataSecuredStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SECURITY_PDU_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataSecurityPDUTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SECURITY_TIME_WINDOW)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataSecurityTimeWindow.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SEGMENTATION_SUPPORTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataSegmentationSupported.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SERIAL_NUMBER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataSerialNumber.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.SETPOINT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataSetpoint.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SETPOINT_REFERENCE)) {
      builder =
          BACnetConstructedDataSetpointReference.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.SETTING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataSetting.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SHED_DURATION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataShedDuration.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SHED_LEVEL_DESCRIPTIONS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataShedLevelDescriptions.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.SHED_LEVELS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataShedLevels.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.SILENCED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataSilenced.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SLAVE_ADDRESS_BINDING)) {
      builder =
          BACnetConstructedDataSlaveAddressBinding.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SLAVE_PROXY_ENABLE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataSlaveProxyEnable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.START_TIME)) {
      builder =
          BACnetConstructedDataStartTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STATE_CHANGE_VALUES)) {
      builder =
          BACnetConstructedDataStateChangeValues.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STATE_DESCRIPTION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataStateDescription.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.STATE_TEXT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataStateText.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STATUS_FLAGS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 8)) {
      builder =
          BACnetConstructedDataStatusFlags.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STOP_TIME)) {
      builder =
          BACnetConstructedDataStopTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STOP_WHEN_FULL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataStopWhenFull.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STRIKE_COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataStrikeCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.STRUCTURED_OBJECT_LIST)) {
      builder =
          BACnetConstructedDataStructuredObjectList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUBORDINATE_ANNOTATIONS)) {
      builder =
          BACnetConstructedDataSubordinateAnnotations.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUBORDINATE_LIST)) {
      builder =
          BACnetConstructedDataSubordinateList.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUBORDINATE_NODE_TYPES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataSubordinateNodeTypes.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUBORDINATE_RELATIONSHIPS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataSubordinateRelationships.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUBORDINATE_TAGS)) {
      builder =
          BACnetConstructedDataSubordinateTags.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUBSCRIBED_RECIPIENTS)) {
      builder =
          BACnetConstructedDataSubscribedRecipients.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUPPORTED_FORMAT_CLASSES)) {
      builder =
          BACnetConstructedDataSupportedFormatClasses.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUPPORTED_FORMATS)) {
      builder =
          BACnetConstructedDataSupportedFormats.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SUPPORTED_SECURITY_ALGORITHMS)) {
      builder =
          BACnetConstructedDataSupportedSecurityAlgorithms.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.SYSTEM_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataSystemStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.TAGS)) {
      builder =
          BACnetConstructedDataTags.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.THREAT_AUTHORITY)) {
      builder =
          BACnetConstructedDataThreatAuthority.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.THREAT_LEVEL)) {
      builder =
          BACnetConstructedDataThreatLevel.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_DELAY)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTimeDelay.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_DELAY_NORMAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTimeDelayNormal.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_OF_ACTIVE_TIME_RESET)) {
      builder =
          BACnetConstructedDataTimeOfActiveTimeReset.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_OF_DEVICE_RESTART)) {
      builder =
          BACnetConstructedDataTimeOfDeviceRestart.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_OF_STATE_COUNT_RESET)) {
      builder =
          BACnetConstructedDataTimeOfStateCountReset.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_OF_STRIKE_COUNT_RESET)) {
      builder =
          BACnetConstructedDataTimeOfStrikeCountReset.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_SYNCHRONIZATION_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTimeSynchronizationInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIME_SYNCHRONIZATION_RECIPIENTS)) {
      builder =
          BACnetConstructedDataTimeSynchronizationRecipients
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TIMER_RUNNING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataTimerRunning.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.TIMER_STATE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataTimerState.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TOTAL_RECORD_COUNT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTotalRecordCount.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.TRACE_FLAG)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataTraceFlag.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TRACKING_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLightingOutputTrackingValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.LIGHTING_OUTPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TRACKING_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataLightingOutputTrackingValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TRACKING_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataTrackingValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.TRANSACTION_NOTIFICATION_CLASS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataTransactionNotificationClass.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.TRANSITION)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataTransition.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.TRIGGER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 1)) {
      builder =
          BACnetConstructedDataTrigger.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.UNITS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataUnits.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.UPDATE_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataUpdateInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.UPDATE_KEY_SET_TIMEOUT)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataUpdateKeySetTimeout.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (EvaluationHelper.equals(objectTypeArgument, BACnetObjectType.CREDENTIAL_DATA_INPUT)
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.UPDATE_TIME)) {
      builder =
          BACnetConstructedDataCredentialDataInputUpdateTime
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.UPDATE_TIME)) {
      builder =
          BACnetConstructedDataUpdateTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.USER_EXTERNAL_IDENTIFIER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataUserExternalIdentifier.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.USER_INFORMATION_REFERENCE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataUserInformationReference.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.USER_NAME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataUserName.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.USER_TYPE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataUserType.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.USES_REMAINING)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataUsesRemaining.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.UTC_OFFSET)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataUTCOffset.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument,
            BACnetPropertyIdentifier.UTC_TIME_SYNCHRONIZATION_RECIPIENTS)) {
      builder =
          BACnetConstructedDataUTCTimeSynchronizationRecipients
              .staticParseBACnetConstructedDataBuilder(
                  readBuffer,
                  tagNumber,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VALID_SAMPLES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataValidSamples.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VALUE_BEFORE_CHANGE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataValueBeforeChange.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VALUE_CHANGE_TIME)) {
      builder =
          BACnetConstructedDataValueChangeTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.VALUE_SET)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataValueSet.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VALUE_SOURCE)) {
      builder =
          BACnetConstructedDataValueSource.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VALUE_SOURCE_ARRAY)) {
      builder =
          BACnetConstructedDataValueSourceArray.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VARIANCE_VALUE)
        && EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetConstructedDataVarianceValue.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VENDOR_IDENTIFIER)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataVendorIdentifier.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.VENDOR_NAME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 7)) {
      builder =
          BACnetConstructedDataVendorName.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VERIFICATION_TIME)
        && EvaluationHelper.equals(peekedTagNumber, (short) 3)) {
      builder =
          BACnetConstructedDataVerificationTime.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VIRTUAL_MAC_ADDRESS_TABLE)) {
      builder =
          BACnetConstructedDataVirtualMACAddressTable.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.VT_CLASSES_SUPPORTED)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataVTClassesSupported.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.WEEKLY_SCHEDULE)) {
      builder =
          BACnetConstructedDataWeeklySchedule.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.WINDOW_INTERVAL)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataWindowInterval.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.WINDOW_SAMPLES)
        && EvaluationHelper.equals(peekedTagNumber, (short) 2)) {
      builder =
          BACnetConstructedDataWindowSamples.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.WRITE_STATUS)
        && EvaluationHelper.equals(peekedTagNumber, (short) 9)) {
      builder =
          BACnetConstructedDataWriteStatus.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ZONE_FROM)) {
      builder =
          BACnetConstructedDataZoneFrom.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(
            propertyIdentifierArgument, BACnetPropertyIdentifier.ZONE_MEMBERS)) {
      builder =
          BACnetConstructedDataZoneMembers.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true
        && EvaluationHelper.equals(propertyIdentifierArgument, BACnetPropertyIdentifier.ZONE_TO)) {
      builder =
          BACnetConstructedDataZoneTo.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    } else if (true) {
      builder =
          BACnetConstructedDataUnspecified.staticParseBACnetConstructedDataBuilder(
              readBuffer,
              tagNumber,
              objectTypeArgument,
              propertyIdentifierArgument,
              arrayIndexArgument);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "objectTypeArgument="
              + objectTypeArgument
              + " "
              + "propertyIdentifierArgument="
              + propertyIdentifierArgument
              + " "
              + "peekedTagNumber="
              + peekedTagNumber
              + "]");
    }

    BACnetClosingTag closingTag =
        readSimpleField(
            "closingTag",
            new DataReaderComplexDefault<>(
                () -> BACnetClosingTag.staticParse(readBuffer, (short) (tagNumber)), readBuffer));

    readBuffer.closeContext("BACnetConstructedData");
    // Create the instance
    BACnetConstructedData _bACnetConstructedData =
        builder.build(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
    return _bACnetConstructedData;
  }

  public interface BACnetConstructedDataBuilder {
    BACnetConstructedData build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber,
        BACnetTagPayloadUnsignedInteger arrayIndexArgument);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConstructedData)) {
      return false;
    }
    BACnetConstructedData that = (BACnetConstructedData) o;
    return (getOpeningTag() == that.getOpeningTag())
        && (getPeekedTagHeader() == that.getPeekedTagHeader())
        && (getClosingTag() == that.getClosingTag())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getOpeningTag(), getPeekedTagHeader(), getClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
