/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConstructedDataEventTimeStamps extends BACnetConstructedData implements Message {

  // Accessors for discriminator values.
  public BACnetObjectType getObjectTypeArgument() {
    return null;
  }

  public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
    return BACnetPropertyIdentifier.EVENT_TIME_STAMPS;
  }

  // Properties.
  protected final BACnetApplicationTagUnsignedInteger numberOfDataElements;
  protected final List<BACnetTimeStamp> eventTimeStamps;

  // Arguments.
  protected final Short tagNumber;
  protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

  public BACnetConstructedDataEventTimeStamps(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetApplicationTagUnsignedInteger numberOfDataElements,
      List<BACnetTimeStamp> eventTimeStamps,
      Short tagNumber,
      BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
    this.numberOfDataElements = numberOfDataElements;
    this.eventTimeStamps = eventTimeStamps;
    this.tagNumber = tagNumber;
    this.arrayIndexArgument = arrayIndexArgument;
  }

  public BACnetApplicationTagUnsignedInteger getNumberOfDataElements() {
    return numberOfDataElements;
  }

  public List<BACnetTimeStamp> getEventTimeStamps() {
    return eventTimeStamps;
  }

  public BigInteger getZero() {
    Object o = 0L;
    if (o instanceof BigInteger) return (BigInteger) o;
    return BigInteger.valueOf(((Number) o).longValue());
  }

  public BACnetTimeStamp getToOffnormal() {
    return (BACnetTimeStamp)
        ((((COUNT(getEventTimeStamps())) == (3)) ? getEventTimeStamps().get(0) : null));
  }

  public BACnetTimeStamp getToFault() {
    return (BACnetTimeStamp)
        ((((COUNT(getEventTimeStamps())) == (3)) ? getEventTimeStamps().get(1) : null));
  }

  public BACnetTimeStamp getToNormal() {
    return (BACnetTimeStamp)
        ((((COUNT(getEventTimeStamps())) == (3)) ? getEventTimeStamps().get(2) : null));
  }

  @Override
  protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConstructedDataEventTimeStamps");

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    BigInteger zero = getZero();
    writeBuffer.writeVirtual("zero", zero);

    // Optional Field (numberOfDataElements) (Can be skipped, if the value is null)
    writeOptionalField(
        "numberOfDataElements",
        numberOfDataElements,
        new DataWriterComplexDefault<>(writeBuffer),
        ((arrayIndexArgument) != (null)) && ((arrayIndexArgument.getActualValue()) == (getZero())));

    // Array Field (eventTimeStamps)
    writeComplexTypeArrayField("eventTimeStamps", eventTimeStamps, writeBuffer);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    BACnetTimeStamp toOffnormal = getToOffnormal();
    writeBuffer.writeVirtual("toOffnormal", toOffnormal);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    BACnetTimeStamp toFault = getToFault();
    writeBuffer.writeVirtual("toFault", toFault);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    BACnetTimeStamp toNormal = getToNormal();
    writeBuffer.writeVirtual("toNormal", toNormal);

    writeBuffer.popContext("BACnetConstructedDataEventTimeStamps");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConstructedDataEventTimeStamps _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // A virtual field doesn't have any in- or output.

    // Optional Field (numberOfDataElements)
    if (numberOfDataElements != null) {
      lengthInBits += numberOfDataElements.getLengthInBits();
    }

    // Array field
    if (eventTimeStamps != null) {
      for (Message element : eventTimeStamps) {
        lengthInBits += element.getLengthInBits();
      }
    }

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(
      ReadBuffer readBuffer,
      Short tagNumber,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger arrayIndexArgument)
      throws ParseException {
    readBuffer.pullContext("BACnetConstructedDataEventTimeStamps");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    BigInteger zero = readVirtualField("zero", BigInteger.class, 0L);

    BACnetApplicationTagUnsignedInteger numberOfDataElements =
        readOptionalField(
            "numberOfDataElements",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetApplicationTagUnsignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer),
            ((arrayIndexArgument) != (null)) && ((arrayIndexArgument.getActualValue()) == (zero)));

    List<BACnetTimeStamp> eventTimeStamps =
        readTerminatedArrayField(
            "eventTimeStamps",
            new DataReaderComplexDefault<>(
                () -> BACnetTimeStamp.staticParse(readBuffer), readBuffer),
            () ->
                ((boolean)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper
                        .isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber))));
    BACnetTimeStamp toOffnormal =
        readVirtualField(
            "toOffnormal",
            BACnetTimeStamp.class,
            (((COUNT(eventTimeStamps)) == (3)) ? eventTimeStamps.get(0) : null));
    BACnetTimeStamp toFault =
        readVirtualField(
            "toFault",
            BACnetTimeStamp.class,
            (((COUNT(eventTimeStamps)) == (3)) ? eventTimeStamps.get(1) : null));
    BACnetTimeStamp toNormal =
        readVirtualField(
            "toNormal",
            BACnetTimeStamp.class,
            (((COUNT(eventTimeStamps)) == (3)) ? eventTimeStamps.get(2) : null));
    // Validation
    if (!(((arrayIndexArgument) != (null)) || ((COUNT(eventTimeStamps)) == (3)))) {
      throw new ParseValidationException("eventTimeStamps should have exactly 3 values");
    }

    readBuffer.closeContext("BACnetConstructedDataEventTimeStamps");
    // Create the instance
    return new BACnetConstructedDataEventTimeStampsBuilderImpl(
        numberOfDataElements, eventTimeStamps, tagNumber, arrayIndexArgument);
  }

  public static class BACnetConstructedDataEventTimeStampsBuilderImpl
      implements BACnetConstructedData.BACnetConstructedDataBuilder {
    private final BACnetApplicationTagUnsignedInteger numberOfDataElements;
    private final List<BACnetTimeStamp> eventTimeStamps;
    private final Short tagNumber;
    private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    public BACnetConstructedDataEventTimeStampsBuilderImpl(
        BACnetApplicationTagUnsignedInteger numberOfDataElements,
        List<BACnetTimeStamp> eventTimeStamps,
        Short tagNumber,
        BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
      this.numberOfDataElements = numberOfDataElements;
      this.eventTimeStamps = eventTimeStamps;
      this.tagNumber = tagNumber;
      this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetConstructedDataEventTimeStamps build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber,
        BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
      BACnetConstructedDataEventTimeStamps bACnetConstructedDataEventTimeStamps =
          new BACnetConstructedDataEventTimeStamps(
              openingTag,
              peekedTagHeader,
              closingTag,
              numberOfDataElements,
              eventTimeStamps,
              tagNumber,
              arrayIndexArgument);
      return bACnetConstructedDataEventTimeStamps;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConstructedDataEventTimeStamps)) {
      return false;
    }
    BACnetConstructedDataEventTimeStamps that = (BACnetConstructedDataEventTimeStamps) o;
    return (getNumberOfDataElements() == that.getNumberOfDataElements())
        && (getEventTimeStamps() == that.getEventTimeStamps())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNumberOfDataElements(), getEventTimeStamps());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
