/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetDateTime implements Message {

  // Properties.
  protected final BACnetApplicationTagDate dateValue;
  protected final BACnetApplicationTagTime timeValue;

  public BACnetDateTime(BACnetApplicationTagDate dateValue, BACnetApplicationTagTime timeValue) {
    super();
    this.dateValue = dateValue;
    this.timeValue = timeValue;
  }

  public BACnetApplicationTagDate getDateValue() {
    return dateValue;
  }

  public BACnetApplicationTagTime getTimeValue() {
    return timeValue;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetDateTime");

    // Simple Field (dateValue)
    writeSimpleField("dateValue", dateValue, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (timeValue)
    writeSimpleField("timeValue", timeValue, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetDateTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetDateTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (dateValue)
    lengthInBits += dateValue.getLengthInBits();

    // Simple field (timeValue)
    lengthInBits += timeValue.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetDateTime staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetDateTime staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetDateTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetApplicationTagDate dateValue =
        readSimpleField(
            "dateValue",
            new DataReaderComplexDefault<>(
                () -> (BACnetApplicationTagDate) BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetApplicationTagTime timeValue =
        readSimpleField(
            "timeValue",
            new DataReaderComplexDefault<>(
                () -> (BACnetApplicationTagTime) BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    readBuffer.closeContext("BACnetDateTime");
    // Create the instance
    BACnetDateTime _bACnetDateTime;
    _bACnetDateTime = new BACnetDateTime(dateValue, timeValue);
    return _bACnetDateTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetDateTime)) {
      return false;
    }
    BACnetDateTime that = (BACnetDateTime) o;
    return (getDateValue() == that.getDateValue())
        && (getTimeValue() == that.getTimeValue())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getDateValue(), getTimeValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
