/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetEventNotificationSubscription implements Message {

  // Properties.
  protected final BACnetRecipientEnclosed recipient;
  protected final BACnetContextTagUnsignedInteger processIdentifier;
  protected final BACnetContextTagBoolean issueConfirmedNotifications;
  protected final BACnetContextTagUnsignedInteger timeRemaining;

  public BACnetEventNotificationSubscription(
      BACnetRecipientEnclosed recipient,
      BACnetContextTagUnsignedInteger processIdentifier,
      BACnetContextTagBoolean issueConfirmedNotifications,
      BACnetContextTagUnsignedInteger timeRemaining) {
    super();
    this.recipient = recipient;
    this.processIdentifier = processIdentifier;
    this.issueConfirmedNotifications = issueConfirmedNotifications;
    this.timeRemaining = timeRemaining;
  }

  public BACnetRecipientEnclosed getRecipient() {
    return recipient;
  }

  public BACnetContextTagUnsignedInteger getProcessIdentifier() {
    return processIdentifier;
  }

  public BACnetContextTagBoolean getIssueConfirmedNotifications() {
    return issueConfirmedNotifications;
  }

  public BACnetContextTagUnsignedInteger getTimeRemaining() {
    return timeRemaining;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetEventNotificationSubscription");

    // Simple Field (recipient)
    writeSimpleField("recipient", recipient, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (processIdentifier)
    writeSimpleField(
        "processIdentifier", processIdentifier, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (issueConfirmedNotifications) (Can be skipped, if the value is null)
    writeOptionalField(
        "issueConfirmedNotifications",
        issueConfirmedNotifications,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (timeRemaining)
    writeSimpleField("timeRemaining", timeRemaining, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetEventNotificationSubscription");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetEventNotificationSubscription _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (recipient)
    lengthInBits += recipient.getLengthInBits();

    // Simple field (processIdentifier)
    lengthInBits += processIdentifier.getLengthInBits();

    // Optional Field (issueConfirmedNotifications)
    if (issueConfirmedNotifications != null) {
      lengthInBits += issueConfirmedNotifications.getLengthInBits();
    }

    // Simple field (timeRemaining)
    lengthInBits += timeRemaining.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetEventNotificationSubscription staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetEventNotificationSubscription staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetEventNotificationSubscription");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetRecipientEnclosed recipient =
        readSimpleField(
            "recipient",
            new DataReaderComplexDefault<>(
                () -> BACnetRecipientEnclosed.staticParse(readBuffer, (short) (0)), readBuffer));

    BACnetContextTagUnsignedInteger processIdentifier =
        readSimpleField(
            "processIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagBoolean issueConfirmedNotifications =
        readOptionalField(
            "issueConfirmedNotifications",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (2), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    BACnetContextTagUnsignedInteger timeRemaining =
        readSimpleField(
            "timeRemaining",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetEventNotificationSubscription");
    // Create the instance
    BACnetEventNotificationSubscription _bACnetEventNotificationSubscription;
    _bACnetEventNotificationSubscription =
        new BACnetEventNotificationSubscription(
            recipient, processIdentifier, issueConfirmedNotifications, timeRemaining);
    return _bACnetEventNotificationSubscription;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetEventNotificationSubscription)) {
      return false;
    }
    BACnetEventNotificationSubscription that = (BACnetEventNotificationSubscription) o;
    return (getRecipient() == that.getRecipient())
        && (getProcessIdentifier() == that.getProcessIdentifier())
        && (getIssueConfirmedNotifications() == that.getIssueConfirmedNotifications())
        && (getTimeRemaining() == that.getTimeRemaining())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getRecipient(),
        getProcessIdentifier(),
        getIssueConfirmedNotifications(),
        getTimeRemaining());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
