/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetLandingCallStatus implements Message {

  // Properties.
  protected final BACnetContextTagUnsignedInteger floorNumber;
  protected final BACnetLandingCallStatusCommand command;
  protected final BACnetContextTagCharacterString floorText;

  public BACnetLandingCallStatus(
      BACnetContextTagUnsignedInteger floorNumber,
      BACnetLandingCallStatusCommand command,
      BACnetContextTagCharacterString floorText) {
    super();
    this.floorNumber = floorNumber;
    this.command = command;
    this.floorText = floorText;
  }

  public BACnetContextTagUnsignedInteger getFloorNumber() {
    return floorNumber;
  }

  public BACnetLandingCallStatusCommand getCommand() {
    return command;
  }

  public BACnetContextTagCharacterString getFloorText() {
    return floorText;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetLandingCallStatus");

    // Simple Field (floorNumber)
    writeSimpleField("floorNumber", floorNumber, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (command)
    writeSimpleField("command", command, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (floorText) (Can be skipped, if the value is null)
    writeOptionalField("floorText", floorText, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetLandingCallStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetLandingCallStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (floorNumber)
    lengthInBits += floorNumber.getLengthInBits();

    // Simple field (command)
    lengthInBits += command.getLengthInBits();

    // Optional Field (floorText)
    if (floorText != null) {
      lengthInBits += floorText.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetLandingCallStatus staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetLandingCallStatus staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetLandingCallStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger floorNumber =
        readSimpleField(
            "floorNumber",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetLandingCallStatusCommand command =
        readSimpleField(
            "command",
            new DataReaderComplexDefault<>(
                () -> BACnetLandingCallStatusCommand.staticParse(readBuffer), readBuffer));

    BACnetContextTagCharacterString floorText =
        readOptionalField(
            "floorText",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagCharacterString)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.CHARACTER_STRING)),
                readBuffer));

    readBuffer.closeContext("BACnetLandingCallStatus");
    // Create the instance
    BACnetLandingCallStatus _bACnetLandingCallStatus;
    _bACnetLandingCallStatus = new BACnetLandingCallStatus(floorNumber, command, floorText);
    return _bACnetLandingCallStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetLandingCallStatus)) {
      return false;
    }
    BACnetLandingCallStatus that = (BACnetLandingCallStatus) o;
    return (getFloorNumber() == that.getFloorNumber())
        && (getCommand() == that.getCommand())
        && (getFloorText() == that.getFloorText())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFloorNumber(), getCommand(), getFloorText());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
