/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetLogDataLogData extends BACnetLogData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetOpeningTag innerOpeningTag;
  protected final List<BACnetLogDataLogDataEntry> logData;
  protected final BACnetClosingTag innerClosingTag;

  // Arguments.
  protected final Short tagNumber;

  public BACnetLogDataLogData(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetOpeningTag innerOpeningTag,
      List<BACnetLogDataLogDataEntry> logData,
      BACnetClosingTag innerClosingTag,
      Short tagNumber) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber);
    this.innerOpeningTag = innerOpeningTag;
    this.logData = logData;
    this.innerClosingTag = innerClosingTag;
    this.tagNumber = tagNumber;
  }

  public BACnetOpeningTag getInnerOpeningTag() {
    return innerOpeningTag;
  }

  public List<BACnetLogDataLogDataEntry> getLogData() {
    return logData;
  }

  public BACnetClosingTag getInnerClosingTag() {
    return innerClosingTag;
  }

  @Override
  protected void serializeBACnetLogDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetLogDataLogData");

    // Simple Field (innerOpeningTag)
    writeSimpleField(
        "innerOpeningTag", innerOpeningTag, new DataWriterComplexDefault<>(writeBuffer));

    // Array Field (logData)
    writeComplexTypeArrayField("logData", logData, writeBuffer);

    // Simple Field (innerClosingTag)
    writeSimpleField(
        "innerClosingTag", innerClosingTag, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetLogDataLogData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetLogDataLogData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (innerOpeningTag)
    lengthInBits += innerOpeningTag.getLengthInBits();

    // Array field
    if (logData != null) {
      for (Message element : logData) {
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (innerClosingTag)
    lengthInBits += innerClosingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetLogDataBuilder staticParseBACnetLogDataBuilder(
      ReadBuffer readBuffer, Short tagNumber) throws ParseException {
    readBuffer.pullContext("BACnetLogDataLogData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag innerOpeningTag =
        readSimpleField(
            "innerOpeningTag",
            new DataReaderComplexDefault<>(
                () -> BACnetOpeningTag.staticParse(readBuffer, (short) (1)), readBuffer));

    List<BACnetLogDataLogDataEntry> logData =
        readTerminatedArrayField(
            "logData",
            new DataReaderComplexDefault<>(
                () -> BACnetLogDataLogDataEntry.staticParse(readBuffer), readBuffer),
            () ->
                ((boolean)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper
                        .isBACnetConstructedDataClosingTag(readBuffer, false, 1))));

    BACnetClosingTag innerClosingTag =
        readSimpleField(
            "innerClosingTag",
            new DataReaderComplexDefault<>(
                () -> BACnetClosingTag.staticParse(readBuffer, (short) (1)), readBuffer));

    readBuffer.closeContext("BACnetLogDataLogData");
    // Create the instance
    return new BACnetLogDataLogDataBuilderImpl(
        innerOpeningTag, logData, innerClosingTag, tagNumber);
  }

  public static class BACnetLogDataLogDataBuilderImpl
      implements BACnetLogData.BACnetLogDataBuilder {
    private final BACnetOpeningTag innerOpeningTag;
    private final List<BACnetLogDataLogDataEntry> logData;
    private final BACnetClosingTag innerClosingTag;
    private final Short tagNumber;

    public BACnetLogDataLogDataBuilderImpl(
        BACnetOpeningTag innerOpeningTag,
        List<BACnetLogDataLogDataEntry> logData,
        BACnetClosingTag innerClosingTag,
        Short tagNumber) {
      this.innerOpeningTag = innerOpeningTag;
      this.logData = logData;
      this.innerClosingTag = innerClosingTag;
      this.tagNumber = tagNumber;
    }

    public BACnetLogDataLogData build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber) {
      BACnetLogDataLogData bACnetLogDataLogData =
          new BACnetLogDataLogData(
              openingTag,
              peekedTagHeader,
              closingTag,
              innerOpeningTag,
              logData,
              innerClosingTag,
              tagNumber);
      return bACnetLogDataLogData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetLogDataLogData)) {
      return false;
    }
    BACnetLogDataLogData that = (BACnetLogDataLogData) o;
    return (getInnerOpeningTag() == that.getInnerOpeningTag())
        && (getLogData() == that.getLogData())
        && (getInnerClosingTag() == that.getInnerClosingTag())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getInnerOpeningTag(), getLogData(), getInnerClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
