/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetLogRecordLogDatumTimeChange extends BACnetLogRecordLogDatum implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetContextTagReal timeChange;

  // Arguments.
  protected final Short tagNumber;

  public BACnetLogRecordLogDatumTimeChange(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetContextTagReal timeChange,
      Short tagNumber) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber);
    this.timeChange = timeChange;
    this.tagNumber = tagNumber;
  }

  public BACnetContextTagReal getTimeChange() {
    return timeChange;
  }

  @Override
  protected void serializeBACnetLogRecordLogDatumChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetLogRecordLogDatumTimeChange");

    // Simple Field (timeChange)
    writeSimpleField("timeChange", timeChange, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetLogRecordLogDatumTimeChange");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetLogRecordLogDatumTimeChange _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (timeChange)
    lengthInBits += timeChange.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetLogRecordLogDatumBuilder staticParseBACnetLogRecordLogDatumBuilder(
      ReadBuffer readBuffer, Short tagNumber) throws ParseException {
    readBuffer.pullContext("BACnetLogRecordLogDatumTimeChange");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagReal timeChange =
        readSimpleField(
            "timeChange",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (9), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    readBuffer.closeContext("BACnetLogRecordLogDatumTimeChange");
    // Create the instance
    return new BACnetLogRecordLogDatumTimeChangeBuilderImpl(timeChange, tagNumber);
  }

  public static class BACnetLogRecordLogDatumTimeChangeBuilderImpl
      implements BACnetLogRecordLogDatum.BACnetLogRecordLogDatumBuilder {
    private final BACnetContextTagReal timeChange;
    private final Short tagNumber;

    public BACnetLogRecordLogDatumTimeChangeBuilderImpl(
        BACnetContextTagReal timeChange, Short tagNumber) {
      this.timeChange = timeChange;
      this.tagNumber = tagNumber;
    }

    public BACnetLogRecordLogDatumTimeChange build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber) {
      BACnetLogRecordLogDatumTimeChange bACnetLogRecordLogDatumTimeChange =
          new BACnetLogRecordLogDatumTimeChange(
              openingTag, peekedTagHeader, closingTag, timeChange, tagNumber);
      return bACnetLogRecordLogDatumTimeChange;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetLogRecordLogDatumTimeChange)) {
      return false;
    }
    BACnetLogRecordLogDatumTimeChange that = (BACnetLogRecordLogDatumTimeChange) o;
    return (getTimeChange() == that.getTimeChange()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTimeChange());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
