/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetNetworkSecurityPolicy implements Message {

  // Properties.
  protected final BACnetContextTagUnsignedInteger portId;
  protected final BACnetSecurityPolicyTagged securityLevel;

  public BACnetNetworkSecurityPolicy(
      BACnetContextTagUnsignedInteger portId, BACnetSecurityPolicyTagged securityLevel) {
    super();
    this.portId = portId;
    this.securityLevel = securityLevel;
  }

  public BACnetContextTagUnsignedInteger getPortId() {
    return portId;
  }

  public BACnetSecurityPolicyTagged getSecurityLevel() {
    return securityLevel;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetNetworkSecurityPolicy");

    // Simple Field (portId)
    writeSimpleField("portId", portId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (securityLevel)
    writeSimpleField("securityLevel", securityLevel, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetNetworkSecurityPolicy");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetNetworkSecurityPolicy _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (portId)
    lengthInBits += portId.getLengthInBits();

    // Simple field (securityLevel)
    lengthInBits += securityLevel.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetNetworkSecurityPolicy staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetNetworkSecurityPolicy staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetNetworkSecurityPolicy");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger portId =
        readSimpleField(
            "portId",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetSecurityPolicyTagged securityLevel =
        readSimpleField(
            "securityLevel",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetSecurityPolicyTagged.staticParse(
                        readBuffer, (short) (1), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    readBuffer.closeContext("BACnetNetworkSecurityPolicy");
    // Create the instance
    BACnetNetworkSecurityPolicy _bACnetNetworkSecurityPolicy;
    _bACnetNetworkSecurityPolicy = new BACnetNetworkSecurityPolicy(portId, securityLevel);
    return _bACnetNetworkSecurityPolicy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetNetworkSecurityPolicy)) {
      return false;
    }
    BACnetNetworkSecurityPolicy that = (BACnetNetworkSecurityPolicy) o;
    return (getPortId() == that.getPortId())
        && (getSecurityLevel() == that.getSecurityLevel())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPortId(), getSecurityLevel());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
