/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetNotificationParametersChangeOfValueNewValueChangedValue
    extends BACnetNotificationParametersChangeOfValueNewValue implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetContextTagReal changedValue;

  // Arguments.
  protected final Short tagNumber;

  public BACnetNotificationParametersChangeOfValueNewValueChangedValue(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetContextTagReal changedValue,
      Short tagNumber) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber);
    this.changedValue = changedValue;
    this.tagNumber = tagNumber;
  }

  public BACnetContextTagReal getChangedValue() {
    return changedValue;
  }

  @Override
  protected void serializeBACnetNotificationParametersChangeOfValueNewValueChild(
      WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetNotificationParametersChangeOfValueNewValueChangedValue");

    // Simple Field (changedValue)
    writeSimpleField("changedValue", changedValue, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetNotificationParametersChangeOfValueNewValueChangedValue");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetNotificationParametersChangeOfValueNewValueChangedValue _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (changedValue)
    lengthInBits += changedValue.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetNotificationParametersChangeOfValueNewValueBuilder
      staticParseBACnetNotificationParametersChangeOfValueNewValueBuilder(
          ReadBuffer readBuffer, Short peekedTagNumber, Short tagNumber) throws ParseException {
    readBuffer.pullContext("BACnetNotificationParametersChangeOfValueNewValueChangedValue");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagReal changedValue =
        readSimpleField(
            "changedValue",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    readBuffer.closeContext("BACnetNotificationParametersChangeOfValueNewValueChangedValue");
    // Create the instance
    return new BACnetNotificationParametersChangeOfValueNewValueChangedValueBuilderImpl(
        changedValue, tagNumber);
  }

  public static class BACnetNotificationParametersChangeOfValueNewValueChangedValueBuilderImpl
      implements BACnetNotificationParametersChangeOfValueNewValue
          .BACnetNotificationParametersChangeOfValueNewValueBuilder {
    private final BACnetContextTagReal changedValue;
    private final Short tagNumber;

    public BACnetNotificationParametersChangeOfValueNewValueChangedValueBuilderImpl(
        BACnetContextTagReal changedValue, Short tagNumber) {
      this.changedValue = changedValue;
      this.tagNumber = tagNumber;
    }

    public BACnetNotificationParametersChangeOfValueNewValueChangedValue build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber) {
      BACnetNotificationParametersChangeOfValueNewValueChangedValue
          bACnetNotificationParametersChangeOfValueNewValueChangedValue =
              new BACnetNotificationParametersChangeOfValueNewValueChangedValue(
                  openingTag, peekedTagHeader, closingTag, changedValue, tagNumber);
      return bACnetNotificationParametersChangeOfValueNewValueChangedValue;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetNotificationParametersChangeOfValueNewValueChangedValue)) {
      return false;
    }
    BACnetNotificationParametersChangeOfValueNewValueChangedValue that =
        (BACnetNotificationParametersChangeOfValueNewValueChangedValue) o;
    return (getChangedValue() == that.getChangedValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getChangedValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
