/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetReadAccessPropertyReadResult implements Message {

  // Properties.
  protected final BACnetTagHeader peekedTagHeader;
  protected final BACnetConstructedData propertyValue;
  protected final ErrorEnclosed propertyAccessError;

  // Arguments.
  protected final BACnetObjectType objectTypeArgument;
  protected final BACnetPropertyIdentifier propertyIdentifierArgument;
  protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

  public BACnetReadAccessPropertyReadResult(
      BACnetTagHeader peekedTagHeader,
      BACnetConstructedData propertyValue,
      ErrorEnclosed propertyAccessError,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
    super();
    this.peekedTagHeader = peekedTagHeader;
    this.propertyValue = propertyValue;
    this.propertyAccessError = propertyAccessError;
    this.objectTypeArgument = objectTypeArgument;
    this.propertyIdentifierArgument = propertyIdentifierArgument;
    this.arrayIndexArgument = arrayIndexArgument;
  }

  public BACnetTagHeader getPeekedTagHeader() {
    return peekedTagHeader;
  }

  public BACnetConstructedData getPropertyValue() {
    return propertyValue;
  }

  public ErrorEnclosed getPropertyAccessError() {
    return propertyAccessError;
  }

  public short getPeekedTagNumber() {
    return (short) (getPeekedTagHeader().getActualTagNumber());
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetReadAccessPropertyReadResult");

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short peekedTagNumber = getPeekedTagNumber();
    writeBuffer.writeVirtual("peekedTagNumber", peekedTagNumber);

    // Optional Field (propertyValue) (Can be skipped, if the value is null)
    writeOptionalField(
        "propertyValue",
        propertyValue,
        new DataWriterComplexDefault<>(writeBuffer),
        (getPeekedTagNumber()) == (4));

    // Optional Field (propertyAccessError) (Can be skipped, if the value is null)
    writeOptionalField(
        "propertyAccessError",
        propertyAccessError,
        new DataWriterComplexDefault<>(writeBuffer),
        (getPeekedTagNumber()) == (5));

    writeBuffer.popContext("BACnetReadAccessPropertyReadResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetReadAccessPropertyReadResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // A virtual field doesn't have any in- or output.

    // Optional Field (propertyValue)
    if (propertyValue != null) {
      lengthInBits += propertyValue.getLengthInBits();
    }

    // Optional Field (propertyAccessError)
    if (propertyAccessError != null) {
      lengthInBits += propertyAccessError.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetReadAccessPropertyReadResult staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 3)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 3, but got " + args.length);
    }
    BACnetObjectType objectTypeArgument;
    if (args[0] instanceof BACnetObjectType) {
      objectTypeArgument = (BACnetObjectType) args[0];
    } else if (args[0] instanceof String) {
      objectTypeArgument = BACnetObjectType.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type BACnetObjectType or a string which is parseable but"
              + " was "
              + args[0].getClass().getName());
    }
    BACnetPropertyIdentifier propertyIdentifierArgument;
    if (args[1] instanceof BACnetPropertyIdentifier) {
      propertyIdentifierArgument = (BACnetPropertyIdentifier) args[1];
    } else if (args[1] instanceof String) {
      propertyIdentifierArgument = BACnetPropertyIdentifier.valueOf((String) args[1]);
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type BACnetPropertyIdentifier or a string which is"
              + " parseable but was "
              + args[1].getClass().getName());
    }
    BACnetTagPayloadUnsignedInteger arrayIndexArgument;
    if (args[2] instanceof BACnetTagPayloadUnsignedInteger) {
      arrayIndexArgument = (BACnetTagPayloadUnsignedInteger) args[2];
    } else {
      throw new PlcRuntimeException(
          "Argument 2 expected to be of type BACnetTagPayloadUnsignedInteger or a string which is"
              + " parseable but was "
              + args[2].getClass().getName());
    }
    return staticParse(
        readBuffer, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument);
  }

  public static BACnetReadAccessPropertyReadResult staticParse(
      ReadBuffer readBuffer,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger arrayIndexArgument)
      throws ParseException {
    readBuffer.pullContext("BACnetReadAccessPropertyReadResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetTagHeader peekedTagHeader =
        readPeekField(
            "peekedTagHeader",
            new DataReaderComplexDefault<>(
                () -> BACnetTagHeader.staticParse(readBuffer), readBuffer));
    short peekedTagNumber =
        readVirtualField("peekedTagNumber", short.class, peekedTagHeader.getActualTagNumber());

    BACnetConstructedData propertyValue =
        readOptionalField(
            "propertyValue",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetConstructedData.staticParse(
                        readBuffer,
                        (short) (4),
                        (BACnetObjectType) (objectTypeArgument),
                        (BACnetPropertyIdentifier) (propertyIdentifierArgument),
                        (BACnetTagPayloadUnsignedInteger) (arrayIndexArgument)),
                readBuffer),
            (peekedTagNumber) == (4));
    // Validation
    if (!(((((peekedTagNumber) == (4)) && ((propertyValue) != (null))))
        || ((peekedTagNumber) != (4)))) {
      throw new ParseValidationException("failure parsing field 4");
    }

    ErrorEnclosed propertyAccessError =
        readOptionalField(
            "propertyAccessError",
            new DataReaderComplexDefault<>(
                () -> ErrorEnclosed.staticParse(readBuffer, (short) (5)), readBuffer),
            (peekedTagNumber) == (5));
    // Validation
    if (!(((((peekedTagNumber) == (5)) && ((propertyAccessError) != (null))))
        || ((peekedTagNumber) != (5)))) {
      throw new ParseValidationException("failure parsing field 5");
    }
    // Validation
    if (!(((peekedTagNumber) == (4)) || ((peekedTagNumber) == (5)))) {
      throw new ParseAssertException("should be either 4 or 5");
    }

    readBuffer.closeContext("BACnetReadAccessPropertyReadResult");
    // Create the instance
    BACnetReadAccessPropertyReadResult _bACnetReadAccessPropertyReadResult;
    _bACnetReadAccessPropertyReadResult =
        new BACnetReadAccessPropertyReadResult(
            peekedTagHeader,
            propertyValue,
            propertyAccessError,
            objectTypeArgument,
            propertyIdentifierArgument,
            arrayIndexArgument);
    return _bACnetReadAccessPropertyReadResult;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetReadAccessPropertyReadResult)) {
      return false;
    }
    BACnetReadAccessPropertyReadResult that = (BACnetReadAccessPropertyReadResult) o;
    return (getPeekedTagHeader() == that.getPeekedTagHeader())
        && (getPropertyValue() == that.getPropertyValue())
        && (getPropertyAccessError() == that.getPropertyAccessError())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPeekedTagHeader(), getPropertyValue(), getPropertyAccessError());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
