/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetRouterEntry implements Message {

  // Properties.
  protected final BACnetContextTagUnsignedInteger networkNumber;
  protected final BACnetContextTagOctetString macAddress;
  protected final BACnetRouterEntryStatusTagged status;
  protected final BACnetContextTagOctetString performanceIndex;

  public BACnetRouterEntry(
      BACnetContextTagUnsignedInteger networkNumber,
      BACnetContextTagOctetString macAddress,
      BACnetRouterEntryStatusTagged status,
      BACnetContextTagOctetString performanceIndex) {
    super();
    this.networkNumber = networkNumber;
    this.macAddress = macAddress;
    this.status = status;
    this.performanceIndex = performanceIndex;
  }

  public BACnetContextTagUnsignedInteger getNetworkNumber() {
    return networkNumber;
  }

  public BACnetContextTagOctetString getMacAddress() {
    return macAddress;
  }

  public BACnetRouterEntryStatusTagged getStatus() {
    return status;
  }

  public BACnetContextTagOctetString getPerformanceIndex() {
    return performanceIndex;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetRouterEntry");

    // Simple Field (networkNumber)
    writeSimpleField("networkNumber", networkNumber, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (macAddress)
    writeSimpleField("macAddress", macAddress, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (status)
    writeSimpleField("status", status, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (performanceIndex) (Can be skipped, if the value is null)
    writeOptionalField(
        "performanceIndex", performanceIndex, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetRouterEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetRouterEntry _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (networkNumber)
    lengthInBits += networkNumber.getLengthInBits();

    // Simple field (macAddress)
    lengthInBits += macAddress.getLengthInBits();

    // Simple field (status)
    lengthInBits += status.getLengthInBits();

    // Optional Field (performanceIndex)
    if (performanceIndex != null) {
      lengthInBits += performanceIndex.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetRouterEntry staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetRouterEntry staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetRouterEntry");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger networkNumber =
        readSimpleField(
            "networkNumber",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagOctetString macAddress =
        readSimpleField(
            "macAddress",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagOctetString)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.OCTET_STRING)),
                readBuffer));

    BACnetRouterEntryStatusTagged status =
        readSimpleField(
            "status",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetRouterEntryStatusTagged.staticParse(
                        readBuffer, (short) (1), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetContextTagOctetString performanceIndex =
        readOptionalField(
            "performanceIndex",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagOctetString)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.OCTET_STRING)),
                readBuffer));

    readBuffer.closeContext("BACnetRouterEntry");
    // Create the instance
    BACnetRouterEntry _bACnetRouterEntry;
    _bACnetRouterEntry = new BACnetRouterEntry(networkNumber, macAddress, status, performanceIndex);
    return _bACnetRouterEntry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetRouterEntry)) {
      return false;
    }
    BACnetRouterEntry that = (BACnetRouterEntry) o;
    return (getNetworkNumber() == that.getNetworkNumber())
        && (getMacAddress() == that.getMacAddress())
        && (getStatus() == that.getStatus())
        && (getPerformanceIndex() == that.getPerformanceIndex())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getNetworkNumber(), getMacAddress(), getStatus(), getPerformanceIndex());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
