/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetScaleFloatScale extends BACnetScale implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetContextTagReal floatScale;

  public BACnetScaleFloatScale(BACnetTagHeader peekedTagHeader, BACnetContextTagReal floatScale) {
    super(peekedTagHeader);
    this.floatScale = floatScale;
  }

  public BACnetContextTagReal getFloatScale() {
    return floatScale;
  }

  @Override
  protected void serializeBACnetScaleChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetScaleFloatScale");

    // Simple Field (floatScale)
    writeSimpleField("floatScale", floatScale, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetScaleFloatScale");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetScaleFloatScale _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (floatScale)
    lengthInBits += floatScale.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetScaleBuilder staticParseBACnetScaleBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetScaleFloatScale");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagReal floatScale =
        readSimpleField(
            "floatScale",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (0), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    readBuffer.closeContext("BACnetScaleFloatScale");
    // Create the instance
    return new BACnetScaleFloatScaleBuilderImpl(floatScale);
  }

  public static class BACnetScaleFloatScaleBuilderImpl implements BACnetScale.BACnetScaleBuilder {
    private final BACnetContextTagReal floatScale;

    public BACnetScaleFloatScaleBuilderImpl(BACnetContextTagReal floatScale) {
      this.floatScale = floatScale;
    }

    public BACnetScaleFloatScale build(BACnetTagHeader peekedTagHeader) {
      BACnetScaleFloatScale bACnetScaleFloatScale =
          new BACnetScaleFloatScale(peekedTagHeader, floatScale);
      return bACnetScaleFloatScale;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetScaleFloatScale)) {
      return false;
    }
    BACnetScaleFloatScale that = (BACnetScaleFloatScale) o;
    return (getFloatScale() == that.getFloatScale()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getFloatScale());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
