/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetTagPayloadBoolean implements Message {

  // Arguments.
  protected final Long actualLength;

  public BACnetTagPayloadBoolean(Long actualLength) {
    super();
    this.actualLength = actualLength;
  }

  public boolean getValue() {
    return (boolean) ((actualLength) == (1));
  }

  public boolean getIsTrue() {
    return (boolean) (getValue());
  }

  public boolean getIsFalse() {
    return (boolean) (!(getValue()));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetTagPayloadBoolean");

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean value = getValue();
    writeBuffer.writeVirtual("value", value);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isTrue = getIsTrue();
    writeBuffer.writeVirtual("isTrue", isTrue);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isFalse = getIsFalse();
    writeBuffer.writeVirtual("isFalse", isFalse);

    writeBuffer.popContext("BACnetTagPayloadBoolean");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetTagPayloadBoolean _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static BACnetTagPayloadBoolean staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Long actualLength;
    if (args[0] instanceof Long) {
      actualLength = (Long) args[0];
    } else if (args[0] instanceof String) {
      actualLength = Long.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Long or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, actualLength);
  }

  public static BACnetTagPayloadBoolean staticParse(ReadBuffer readBuffer, Long actualLength)
      throws ParseException {
    readBuffer.pullContext("BACnetTagPayloadBoolean");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    boolean value = readVirtualField("value", boolean.class, (actualLength) == (1));
    boolean isTrue = readVirtualField("isTrue", boolean.class, value);
    boolean isFalse = readVirtualField("isFalse", boolean.class, !(value));

    readBuffer.closeContext("BACnetTagPayloadBoolean");
    // Create the instance
    BACnetTagPayloadBoolean _bACnetTagPayloadBoolean;
    _bACnetTagPayloadBoolean = new BACnetTagPayloadBoolean(actualLength);

    return _bACnetTagPayloadBoolean;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetTagPayloadBoolean)) {
      return false;
    }
    BACnetTagPayloadBoolean that = (BACnetTagPayloadBoolean) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
