/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.bacnetip.configuration.BacNetIpConfiguration;
import org.apache.plc4x.java.bacnetip.protocol.BacNetIpProtocolLogic;
import org.apache.plc4x.java.bacnetip.readwrite.BVLC;
import org.apache.plc4x.java.bacnetip.tag.BacNetIpTagHandler;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class BacNetIpDriver
extends GeneratedDriverBase<BVLC> {
    public String getProtocolCode() {
        return "bacnet-ip";
    }

    public String getProtocolName() {
        return "BACnet/IP";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return BacNetIpConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "udp";
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return false;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected BacNetIpTagHandler getTagHandler() {
        return new BacNetIpTagHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new org.apache.plc4x.java.spi.values.PlcValueHandler();
    }

    protected ProtocolStackConfigurer<BVLC> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(BVLC.class, (readBuffer, objectArray) -> BVLC.staticParse(readBuffer, objectArray)).withProtocol(BacNetIpProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).build();
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2);
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != BVLC.BACNETTYPE.shortValue()) {
                byteBuf.readByte();
            }
        }
    }
}

