/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.configuration;

import org.apache.plc4x.java.bacnetip.readwrite.BacnetConstants;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.DoubleDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;
import org.apache.plc4x.java.transport.pcapreplay.PcapReplayTransportConfiguration;
import org.apache.plc4x.java.transport.rawsocket.RawSocketTransportConfiguration;
import org.apache.plc4x.java.transport.udp.UdpTransportConfiguration;
import org.apache.plc4x.java.utils.pcap.netty.handlers.PacketHandler;
import org.pcap4j.packet.Dot1qVlanTagPacket;

public class BacNetIpConfiguration
implements Configuration,
UdpTransportConfiguration,
RawSocketTransportConfiguration,
PcapReplayTransportConfiguration {
    @ConfigurationParameter(value="ede-file-path")
    private String edeFilePath;
    @ConfigurationParameter(value="ede-directory-path")
    private String edeDirectoryPath;
    @ConfigurationParameter(value="pcap-replay-speed")
    @DoubleDefaultValue(value=1.0)
    private double pcapReplaySpeed;
    @ConfigurationParameter(value="filter")
    @StringDefaultValue(value="")
    private String filter = "";

    public String getEdeFilePath() {
        return this.edeFilePath;
    }

    public void setEdeFilePath(String edeFilePath) {
        this.edeFilePath = edeFilePath;
    }

    public String getEdeDirectoryPath() {
        return this.edeDirectoryPath;
    }

    public void setEdeDirectoryPath(String edeDirectoryPath) {
        this.edeDirectoryPath = edeDirectoryPath;
    }

    public void setPcapReplaySpeed(double pcapReplaySpeed) {
        this.pcapReplaySpeed = pcapReplaySpeed;
    }

    public float getReplaySpeedFactor() {
        return (float)this.pcapReplaySpeed;
    }

    public boolean getSupportVlans() {
        return true;
    }

    public int getDefaultPort() {
        return BacnetConstants.BACNETUDPDEFAULTPORT;
    }

    public Integer getProtocolId() {
        return null;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public PacketHandler getPcapPacketHandler() {
        return packet -> {
            if (packet.getPayload() instanceof Dot1qVlanTagPacket) {
                return packet.getPayload().getPayload().getPayload().getPayload().getRawData();
            }
            if (packet.getPayload() != null && packet.getPayload().getPayload() != null && packet.getPayload().getPayload().getPayload() != null) {
                return packet.getPayload().getPayload().getPayload().getRawData();
            }
            return null;
        };
    }
}

