/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.ede.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.bacnetip.tag.BacNetIpTag;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcSTRING;

public class Datapoint {
    private final BacNetIpTag address;
    private final String keyName;
    private final String objectName;
    private final String description;
    private final Double defaultValue;
    private final Double minValue;
    private final Double maxValue;
    private final Boolean commandable;
    private final Boolean supportsCov;
    private final Double hiLimit;
    private final Double lowLimit;
    private final String stateTextReference;
    private final Integer unitCode;
    private final Integer vendorSpecificAddress;
    private final Integer notificationClass;

    public Datapoint(BacNetIpTag address, String keyName, String objectName, String description, Double defaultValue, Double minValue, Double maxValue, Boolean commandable, Boolean supportsCov, Double hiLimit, Double lowLimit, String stateTextReference, Integer unitCode, Integer vendorSpecificAddress, Integer notificationClass) {
        this.address = address;
        this.keyName = keyName;
        this.objectName = objectName;
        this.description = description;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.commandable = commandable;
        this.supportsCov = supportsCov;
        this.hiLimit = hiLimit;
        this.lowLimit = lowLimit;
        this.stateTextReference = stateTextReference;
        this.unitCode = unitCode;
        this.vendorSpecificAddress = vendorSpecificAddress;
        this.notificationClass = notificationClass;
    }

    public BacNetIpTag getAddress() {
        return this.address;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Boolean getCommandable() {
        return this.commandable;
    }

    public Boolean getSupportsCov() {
        return this.supportsCov;
    }

    public Double getHiLimit() {
        return this.hiLimit;
    }

    public Double getLowLimit() {
        return this.lowLimit;
    }

    public String getStateTextReference() {
        return this.stateTextReference;
    }

    public Integer getUnitCode() {
        return this.unitCode;
    }

    public Integer getVendorSpecificAddress() {
        return this.vendorSpecificAddress;
    }

    public Integer getNotificationClass() {
        return this.notificationClass;
    }

    public Map<String, PlcValue> toPlcValues() {
        HashMap<String, PlcValue> values = new HashMap<String, PlcValue>();
        values.put("keyName", (PlcValue)(this.keyName == null ? null : new PlcSTRING(this.keyName)));
        values.put("objectName", (PlcValue)(this.objectName == null ? null : new PlcSTRING(this.objectName)));
        values.put("description", (PlcValue)(this.description == null ? null : new PlcSTRING(this.description)));
        values.put("defaultValue", (PlcValue)(this.defaultValue == null ? null : new PlcLREAL(this.defaultValue)));
        values.put("minValue", (PlcValue)(this.minValue == null ? null : new PlcLREAL(this.minValue)));
        values.put("maxValue", (PlcValue)(this.maxValue == null ? null : new PlcLREAL(this.maxValue)));
        values.put("commandable", (PlcValue)(this.commandable == null ? null : new PlcBOOL(this.commandable)));
        values.put("supportsCov", (PlcValue)(this.supportsCov == null ? null : new PlcBOOL(this.supportsCov)));
        values.put("hiLimit", (PlcValue)(this.hiLimit == null ? null : new PlcLREAL(this.hiLimit)));
        values.put("lowLimit", (PlcValue)(this.lowLimit == null ? null : new PlcLREAL(this.lowLimit)));
        values.put("stateTextReference", (PlcValue)(this.stateTextReference == null ? null : new PlcSTRING(this.stateTextReference)));
        values.put("unitCode", (PlcValue)(this.unitCode == null ? null : new PlcDINT(this.unitCode)));
        values.put("vendorSpecificAddress", (PlcValue)(this.vendorSpecificAddress == null ? null : new PlcDINT(this.vendorSpecificAddress)));
        values.put("notificationClass", (PlcValue)(this.notificationClass == null ? null : new PlcDINT(this.notificationClass)));
        return values;
    }
}

