/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.protocol;

import java.io.File;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.bacnetip.configuration.BacNetIpConfiguration;
import org.apache.plc4x.java.bacnetip.ede.EdeParser;
import org.apache.plc4x.java.bacnetip.ede.model.Datapoint;
import org.apache.plc4x.java.bacnetip.ede.model.EdeModel;
import org.apache.plc4x.java.bacnetip.readwrite.APDUComplexAck;
import org.apache.plc4x.java.bacnetip.readwrite.APDUConfirmedRequest;
import org.apache.plc4x.java.bacnetip.readwrite.APDUError;
import org.apache.plc4x.java.bacnetip.readwrite.APDUSimpleAck;
import org.apache.plc4x.java.bacnetip.readwrite.APDUUnconfirmedRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestConfirmedCOVNotification;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestReadProperty;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestSubscribeCOV;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestWriteProperty;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedDataElement;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedDataUnspecified;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyValue;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequestIAm;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequestUnconfirmedCOVNotification;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequestUnconfirmedPrivateTransfer;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequestWhoHas;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequestWhoIs;
import org.apache.plc4x.java.bacnetip.readwrite.BVLC;
import org.apache.plc4x.java.bacnetip.readwrite.BVLCForwardedNPDU;
import org.apache.plc4x.java.bacnetip.readwrite.BVLCOriginalBroadcastNPDU;
import org.apache.plc4x.java.bacnetip.readwrite.BVLCOriginalUnicastNPDU;
import org.apache.plc4x.java.bacnetip.readwrite.NPDU;
import org.apache.plc4x.java.bacnetip.tag.BacNetIpTag;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacNetIpProtocolLogic
extends Plc4xProtocolBase<BVLC>
implements HasConfiguration<BacNetIpConfiguration>,
PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacNetIpProtocolLogic.class);
    private EdeModel edeModel;
    private final Map<Integer, Consumer<PlcSubscriptionEvent>> consumerIdMap = new ConcurrentHashMap<Integer, Consumer<PlcSubscriptionEvent>>();

    public void setConfiguration(BacNetIpConfiguration configuration) {
        if (configuration.getEdeFilePath() != null) {
            File edeFile = new File(configuration.getEdeFilePath());
            if (!edeFile.exists() || !edeFile.isFile()) {
                throw new PlcRuntimeException(String.format("File specified with 'ede-file-path' does not exist or is not a file: '%s'", configuration.getEdeFilePath()));
            }
            this.edeModel = new EdeParser().parseFile(edeFile);
        } else if (configuration.getEdeDirectoryPath() != null) {
            File edeDirectory = new File(configuration.getEdeDirectoryPath());
            if (!edeDirectory.exists() || !edeDirectory.isDirectory()) {
                throw new PlcRuntimeException(String.format("File specified with 'ede-directory-path' does not exist or is not a directory: '%s'", configuration.getEdeDirectoryPath()));
            }
            this.edeModel = new EdeParser().parseDirectory(edeDirectory);
        }
    }

    public void onConnect(ConversationContext<BVLC> context) {
        if (!context.isPassive()) {
            throw new PlcRuntimeException("Active connections not yet supported");
        }
        context.fireConnected();
    }

    public void close(ConversationContext<BVLC> context) {
    }

    protected void decode(ConversationContext<BVLC> context, BVLC msg) throws Exception {
        NPDU npdu = null;
        if (msg instanceof BVLCOriginalUnicastNPDU) {
            BVLCOriginalUnicastNPDU bvlcOriginalUnicastNPDU = (BVLCOriginalUnicastNPDU)msg;
            npdu = bvlcOriginalUnicastNPDU.getNpdu();
        } else if (msg instanceof BVLCForwardedNPDU) {
            BVLCForwardedNPDU bvlcForwardedNPDU = (BVLCForwardedNPDU)msg;
            npdu = bvlcForwardedNPDU.getNpdu();
        } else if (msg instanceof BVLCOriginalBroadcastNPDU) {
            BVLCOriginalBroadcastNPDU bvlcOriginalBroadcastNPDU = (BVLCOriginalBroadcastNPDU)msg;
            npdu = bvlcOriginalBroadcastNPDU.getNpdu();
        }
        if (npdu == null) {
            LOGGER.warn("Ummapped BVLC {}", (Object)msg);
            return;
        }
        if (npdu.getApdu() instanceof APDUConfirmedRequest) {
            APDUConfirmedRequest apduConfirmedRequest = (APDUConfirmedRequest)npdu.getApdu();
            this.decodeConfirmedRequest(apduConfirmedRequest);
        } else if (npdu.getApdu() instanceof APDUUnconfirmedRequest) {
            APDUUnconfirmedRequest unconfirmedRequest = (APDUUnconfirmedRequest)npdu.getApdu();
            this.decodeUnconfirmedRequest(unconfirmedRequest);
        } else if (npdu.getApdu() instanceof APDUError) {
            APDUError aPDUError = (APDUError)npdu.getApdu();
        } else if (!(npdu.getApdu() instanceof APDUSimpleAck || npdu.getApdu() instanceof APDUComplexAck || npdu.getApdu() == null && npdu.getNlm() != null)) {
            LOGGER.debug(String.format("Unexpected NPDU type: %s", npdu.getClass().getName()));
        }
    }

    private void decodeConfirmedRequest(APDUConfirmedRequest apduConfirmedRequest) {
        BACnetConfirmedServiceRequest serviceRequest = apduConfirmedRequest.getServiceRequest();
        if (serviceRequest instanceof BACnetConfirmedServiceRequestConfirmedCOVNotification) {
            BACnetConfirmedServiceRequestConfirmedCOVNotification valueChange = (BACnetConfirmedServiceRequestConfirmedCOVNotification)serviceRequest;
            long deviceIdentifier = valueChange.getMonitoredObjectIdentifier().getPayload().getInstanceNumber();
            short objectType = valueChange.getMonitoredObjectIdentifier().getPayload().getObjectType().getValue();
            long objectInstance = valueChange.getMonitoredObjectIdentifier().getPayload().getInstanceNumber();
            BacNetIpTag curTag = new BacNetIpTag(deviceIdentifier, objectType, objectInstance);
            for (BACnetPropertyValue baCnetPropertyValue : valueChange.getListOfValues().getData()) {
                Datapoint datapoint;
                if (baCnetPropertyValue.getPropertyIdentifier().getValue() != BACnetPropertyIdentifier.PRESENT_VALUE) continue;
                BACnetConstructedDataElement propertyValue = baCnetPropertyValue.getPropertyValue();
                HashMap<String, Object> enrichedPlcValue = new HashMap<String, Object>();
                enrichedPlcValue.put("deviceIdentifier", new PlcUDINT(deviceIdentifier));
                enrichedPlcValue.put("objectType", new PlcDINT((int)objectType));
                enrichedPlcValue.put("objectInstance", new PlcUDINT(objectInstance));
                enrichedPlcValue.put("address", new PlcSTRING(this.toString(curTag)));
                enrichedPlcValue.put("tagNumber", PlcValueHandler.of((Object)propertyValue.getPeekedTagHeader().getActualTagNumber()));
                enrichedPlcValue.put("lengthValueType", PlcValueHandler.of((Object)propertyValue.getPeekedTagHeader().getActualLength()));
                if (this.edeModel != null && (datapoint = this.edeModel.getDatapoint(curTag)) != null) {
                    enrichedPlcValue.putAll(datapoint.toPlcValues());
                }
                this.publishEvent(curTag, (PlcValue)new PlcStruct(enrichedPlcValue));
            }
        } else if (!(serviceRequest instanceof BACnetConfirmedServiceRequestReadProperty || serviceRequest instanceof BACnetConfirmedServiceRequestWriteProperty || serviceRequest instanceof BACnetConfirmedServiceRequestSubscribeCOV)) {
            LOGGER.debug(String.format("Unexpected ConfirmedServiceRequest type: %s", serviceRequest.getClass().getName()));
        }
    }

    private void decodeUnconfirmedRequest(APDUUnconfirmedRequest unconfirmedRequest) {
        BACnetUnconfirmedServiceRequest serviceRequest = unconfirmedRequest.getServiceRequest();
        if (serviceRequest instanceof BACnetUnconfirmedServiceRequestUnconfirmedCOVNotification) {
            BACnetUnconfirmedServiceRequestUnconfirmedCOVNotification valueChange = (BACnetUnconfirmedServiceRequestUnconfirmedCOVNotification)serviceRequest;
            long deviceIdentifier = valueChange.getMonitoredObjectIdentifier().getPayload().getInstanceNumber();
            short objectType = valueChange.getMonitoredObjectIdentifier().getPayload().getObjectType().getValue();
            long objectInstance = valueChange.getMonitoredObjectIdentifier().getPayload().getInstanceNumber();
            BacNetIpTag curTag = new BacNetIpTag(deviceIdentifier, objectType, objectInstance);
            for (BACnetPropertyValue baCnetPropertyValue : valueChange.getListOfValues().getData()) {
                Datapoint datapoint;
                if (baCnetPropertyValue.getPropertyIdentifier().getValue() != BACnetPropertyIdentifier.PRESENT_VALUE) continue;
                BACnetApplicationTag baCnetTag = ((BACnetConstructedDataUnspecified)baCnetPropertyValue.getPropertyValue().getConstructedData()).getData().get(0).getApplicationTag();
                HashMap<String, Object> enrichedPlcValue = new HashMap<String, Object>();
                enrichedPlcValue.put("deviceIdentifier", new PlcUDINT(deviceIdentifier));
                enrichedPlcValue.put("objectType", new PlcDINT((int)objectType));
                enrichedPlcValue.put("objectInstance", new PlcUDINT(objectInstance));
                enrichedPlcValue.put("address", new PlcSTRING(this.toString(curTag)));
                enrichedPlcValue.put("tagNumber", PlcValueHandler.of((Object)baCnetTag.getActualTagNumber()));
                enrichedPlcValue.put("lengthValueType", PlcValueHandler.of((Object)baCnetTag.getActualLength()));
                if (this.edeModel != null && (datapoint = this.edeModel.getDatapoint(curTag)) != null) {
                    enrichedPlcValue.putAll(datapoint.toPlcValues());
                }
                this.publishEvent(curTag, (PlcValue)new PlcStruct(enrichedPlcValue));
            }
        } else if (!(serviceRequest instanceof BACnetUnconfirmedServiceRequestWhoHas || serviceRequest instanceof BACnetUnconfirmedServiceRequestWhoIs || serviceRequest instanceof BACnetUnconfirmedServiceRequestIAm || serviceRequest instanceof BACnetUnconfirmedServiceRequestUnconfirmedPrivateTransfer)) {
            LOGGER.debug(String.format("Unexpected UnconfirmedServiceRequest type: %s", serviceRequest.getClass().getName()));
        }
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        for (String tagName : subscriptionRequest.getTagNames()) {
            values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)new DefaultPlcSubscriptionHandle((PlcSubscriber)this)));
        }
        return CompletableFuture.completedFuture(new DefaultPlcSubscriptionResponse(subscriptionRequest, values));
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> collection) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, collection.toArray(new PlcSubscriptionHandle[0]));
        this.consumerIdMap.put(consumerRegistration.getConsumerId(), consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration plcConsumerRegistration) {
        DefaultPlcConsumerRegistration consumerRegistration = (DefaultPlcConsumerRegistration)plcConsumerRegistration;
        this.consumerIdMap.remove(consumerRegistration.getConsumerId());
    }

    protected void publishEvent(BacNetIpTag tag, PlcValue plcValue) {
        DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap("event", new ResponseItem(PlcResponseCode.OK, (Object)plcValue)));
        for (Consumer<PlcSubscriptionEvent> consumer : this.consumerIdMap.values()) {
            consumer.accept((PlcSubscriptionEvent)event);
        }
    }

    private String toString(BacNetIpTag tag) {
        return String.valueOf(tag.getDeviceIdentifier()) + "/" + tag.getObjectType() + "/" + tag.getObjectInstance();
    }
}

