/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAbortReasonTagged;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUAbort
extends APDU
implements Message {
    protected final boolean server;
    protected final short originalInvokeId;
    protected final BACnetAbortReasonTagged abortReason;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.ABORT_PDU;
    }

    public APDUAbort(boolean server, short originalInvokeId, BACnetAbortReasonTagged abortReason, Integer apduLength) {
        super(apduLength);
        this.server = server;
        this.originalInvokeId = originalInvokeId;
        this.abortReason = abortReason;
        this.apduLength = apduLength;
    }

    public boolean getServer() {
        return this.server;
    }

    public short getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public BACnetAbortReasonTagged getAbortReason() {
        return this.abortReason;
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUAbort", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)3), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"server", (Object)this.server, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalInvokeId", (Object)this.originalInvokeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"abortReason", (Object)this.abortReason, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUAbort", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUAbort _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 3;
        ++lengthInBits;
        lengthInBits += 8;
        return lengthInBits += this.abortReason.getLengthInBits();
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUAbort", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)3), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean server = (Boolean)FieldReaderFactory.readSimpleField((String)"server", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short originalInvokeId = (Short)FieldReaderFactory.readSimpleField((String)"originalInvokeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetAbortReasonTagged abortReason = (BACnetAbortReasonTagged)FieldReaderFactory.readSimpleField((String)"abortReason", (DataReader)new DataReaderComplexDefault(() -> BACnetAbortReasonTagged.staticParse(readBuffer, 1L), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("APDUAbort", new WithReaderArgs[0]);
        return new APDUAbortBuilderImpl(server, originalInvokeId, abortReason, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUAbort)) {
            return false;
        }
        APDUAbort that = (APDUAbort)o;
        return this.getServer() == that.getServer() && this.getOriginalInvokeId() == that.getOriginalInvokeId() && this.getAbortReason() == that.getAbortReason() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServer(), this.getOriginalInvokeId(), this.getAbortReason());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUAbortBuilderImpl
    implements APDU.APDUBuilder {
        private final boolean server;
        private final short originalInvokeId;
        private final BACnetAbortReasonTagged abortReason;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDUAbortBuilderImpl(boolean server, short originalInvokeId, BACnetAbortReasonTagged abortReason, Integer apduLength, Byte reservedField0) {
            this.server = server;
            this.originalInvokeId = originalInvokeId;
            this.abortReason = abortReason;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUAbort build(Integer apduLength) {
            APDUAbort aPDUAbort = new APDUAbort(this.server, this.originalInvokeId, this.abortReason, apduLength);
            aPDUAbort.reservedField0 = this.reservedField0;
            return aPDUAbort;
        }
    }
}

