/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetError;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUError
extends APDU
implements Message {
    protected final short originalInvokeId;
    protected final BACnetConfirmedServiceChoice errorChoice;
    protected final BACnetError error;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.ERROR_PDU;
    }

    public APDUError(short originalInvokeId, BACnetConfirmedServiceChoice errorChoice, BACnetError error, Integer apduLength) {
        super(apduLength);
        this.originalInvokeId = originalInvokeId;
        this.errorChoice = errorChoice;
        this.error = error;
        this.apduLength = apduLength;
    }

    public short getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public BACnetConfirmedServiceChoice getErrorChoice() {
        return this.errorChoice;
    }

    public BACnetError getError() {
        return this.error;
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUError", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalInvokeId", (Object)this.originalInvokeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"errorChoice", (String)"BACnetConfirmedServiceChoice", (Object)((Object)this.errorChoice), (DataWriter)new DataWriterEnumDefault(BACnetConfirmedServiceChoice::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"error", (Object)this.error, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUError", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUError _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += this.error.getLengthInBits();
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUError", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        short originalInvokeId = (Short)FieldReaderFactory.readSimpleField((String)"originalInvokeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConfirmedServiceChoice errorChoice = (BACnetConfirmedServiceChoice)((Object)FieldReaderFactory.readEnumField((String)"errorChoice", (String)"BACnetConfirmedServiceChoice", (DataReader)new DataReaderEnumDefault(BACnetConfirmedServiceChoice::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        BACnetError error = (BACnetError)FieldReaderFactory.readSimpleField((String)"error", (DataReader)new DataReaderComplexDefault(() -> BACnetError.staticParse(readBuffer, errorChoice), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("APDUError", new WithReaderArgs[0]);
        return new APDUErrorBuilderImpl(originalInvokeId, errorChoice, error, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUError)) {
            return false;
        }
        APDUError that = (APDUError)o;
        return this.getOriginalInvokeId() == that.getOriginalInvokeId() && this.getErrorChoice() == that.getErrorChoice() && this.getError() == that.getError() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getOriginalInvokeId(), this.getErrorChoice(), this.getError()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUErrorBuilderImpl
    implements APDU.APDUBuilder {
        private final short originalInvokeId;
        private final BACnetConfirmedServiceChoice errorChoice;
        private final BACnetError error;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDUErrorBuilderImpl(short originalInvokeId, BACnetConfirmedServiceChoice errorChoice, BACnetError error, Integer apduLength, Byte reservedField0) {
            this.originalInvokeId = originalInvokeId;
            this.errorChoice = errorChoice;
            this.error = error;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUError build(Integer apduLength) {
            APDUError aPDUError = new APDUError(this.originalInvokeId, this.errorChoice, this.error, apduLength);
            aPDUError.reservedField0 = this.reservedField0;
            return aPDUError;
        }
    }
}

