/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetRejectReasonTagged;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUReject
extends APDU
implements Message {
    protected final short originalInvokeId;
    protected final BACnetRejectReasonTagged rejectReason;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.REJECT_PDU;
    }

    public APDUReject(short originalInvokeId, BACnetRejectReasonTagged rejectReason, Integer apduLength) {
        super(apduLength);
        this.originalInvokeId = originalInvokeId;
        this.rejectReason = rejectReason;
        this.apduLength = apduLength;
    }

    public short getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public BACnetRejectReasonTagged getRejectReason() {
        return this.rejectReason;
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUReject", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalInvokeId", (Object)this.originalInvokeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"rejectReason", (Object)this.rejectReason, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUReject", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUReject _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        lengthInBits += 8;
        return lengthInBits += this.rejectReason.getLengthInBits();
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUReject", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        short originalInvokeId = (Short)FieldReaderFactory.readSimpleField((String)"originalInvokeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetRejectReasonTagged rejectReason = (BACnetRejectReasonTagged)FieldReaderFactory.readSimpleField((String)"rejectReason", (DataReader)new DataReaderComplexDefault(() -> BACnetRejectReasonTagged.staticParse(readBuffer, 1L), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("APDUReject", new WithReaderArgs[0]);
        return new APDURejectBuilderImpl(originalInvokeId, rejectReason, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUReject)) {
            return false;
        }
        APDUReject that = (APDUReject)o;
        return this.getOriginalInvokeId() == that.getOriginalInvokeId() && this.getRejectReason() == that.getRejectReason() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOriginalInvokeId(), this.getRejectReason());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDURejectBuilderImpl
    implements APDU.APDUBuilder {
        private final short originalInvokeId;
        private final BACnetRejectReasonTagged rejectReason;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDURejectBuilderImpl(short originalInvokeId, BACnetRejectReasonTagged rejectReason, Integer apduLength, Byte reservedField0) {
            this.originalInvokeId = originalInvokeId;
            this.rejectReason = rejectReason;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUReject build(Integer apduLength) {
            APDUReject aPDUReject = new APDUReject(this.originalInvokeId, this.rejectReason, apduLength);
            aPDUReject.reservedField0 = this.reservedField0;
            return aPDUReject;
        }
    }
}

