/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum ApduType {
    CONFIRMED_REQUEST_PDU(0),
    UNCONFIRMED_REQUEST_PDU(1),
    SIMPLE_ACK_PDU(2),
    COMPLEX_ACK_PDU(3),
    SEGMENT_ACK_PDU(4),
    ERROR_PDU(5),
    REJECT_PDU(6),
    ABORT_PDU(7),
    APDU_UNKNOWN_8(8),
    APDU_UNKNOWN_9(9),
    APDU_UNKNOWN_A(10),
    APDU_UNKNOWN_B(11),
    APDU_UNKNOWN_C(12),
    APDU_UNKNOWN_D(13),
    APDU_UNKNOWN_E(14),
    APDU_UNKNOWN_F(15);

    private static final Map<Byte, ApduType> map;
    private final byte value;

    static {
        map = new HashMap<Byte, ApduType>();
        ApduType[] apduTypeArray = ApduType.values();
        int n = apduTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ApduType value = apduTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private ApduType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static ApduType enumForValue(byte value) {
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }
}

