/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum BACnetAccessEvent {
    NONE(0),
    GRANTED(1),
    MUSTER(2),
    PASSBACK_DETECTED(3),
    DURESS(4),
    TRACE(5),
    LOCKOUT_MAX_ATTEMPTS(6),
    LOCKOUT_OTHER(7),
    LOCKOUT_RELINQUISHED(8),
    LOCKED_BY_HIGHER_PRIORITY(9),
    OUT_OF_SERVICE(10),
    OUT_OF_SERVICE_RELINQUISHED(11),
    ACCOMPANIMENT_BY(12),
    AUTHENTICATION_FACTOR_READ(13),
    AUTHORIZATION_DELAYED(14),
    VERIFICATION_REQUIRED(15),
    NO_ENTRY_AFTER_GRANTED(16),
    DENIED_DENY_ALL(128),
    DENIED_UNKNOWN_CREDENTIAL(129),
    DENIED_AUTHENTICATION_UNAVAILABLE(130),
    DENIED_AUTHENTICATION_FACTOR_TIMEOUT(131),
    DENIED_INCORRECT_AUTHENTICATION_FACTOR(132),
    DENIED_ZONE_NO_ACCESS_RIGHTS(133),
    DENIED_POINT_NO_ACCESS_RIGHTS(134),
    DENIED_NO_ACCESS_RIGHTS(135),
    DENIED_OUT_OF_TIME_RANGE(136),
    DENIED_THREAT_LEVEL(137),
    DENIED_PASSBACK(138),
    DENIED_UNEXPECTED_LOCATION_USAGE(139),
    DENIED_MAX_ATTEMPTS(140),
    DENIED_LOWER_OCCUPANCY_LIMIT(141),
    DENIED_UPPER_OCCUPANCY_LIMIT(142),
    DENIED_AUTHENTICATION_FACTOR_LOST(143),
    DENIED_AUTHENTICATION_FACTOR_STOLEN(144),
    DENIED_AUTHENTICATION_FACTOR_DAMAGED(145),
    DENIED_AUTHENTICATION_FACTOR_DESTROYED(146),
    DENIED_AUTHENTICATION_FACTOR_DISABLED(147),
    DENIED_AUTHENTICATION_FACTOR_ERROR(148),
    DENIED_CREDENTIAL_UNASSIGNED(149),
    DENIED_CREDENTIAL_NOT_PROVISIONED(150),
    DENIED_CREDENTIAL_NOT_YET_ACTIVE(151),
    DENIED_CREDENTIAL_EXPIRED(152),
    DENIED_CREDENTIAL_MANUAL_DISABLE(153),
    DENIED_CREDENTIAL_LOCKOUT(154),
    DENIED_CREDENTIAL_MAX_DAYS(155),
    DENIED_CREDENTIAL_MAX_USES(156),
    DENIED_CREDENTIAL_INACTIVITY(157),
    DENIED_CREDENTIAL_DISABLED(158),
    DENIED_NO_ACCOMPANIMENT(159),
    DENIED_INCORRECT_ACCOMPANIMENT(160),
    DENIED_LOCKOUT(161),
    DENIED_VERIFICATION_FAILED(162),
    DENIED_VERIFICATION_TIMEOUT(163),
    DENIED_OTHER(164),
    VENDOR_PROPRIETARY_VALUE(65535);

    private static final Map<Integer, BACnetAccessEvent> map;
    private final int value;

    static {
        map = new HashMap<Integer, BACnetAccessEvent>();
        BACnetAccessEvent[] bACnetAccessEventArray = BACnetAccessEvent.values();
        int n = bACnetAccessEventArray.length;
        int n2 = 0;
        while (n2 < n) {
            BACnetAccessEvent value = bACnetAccessEventArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private BACnetAccessEvent(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BACnetAccessEvent enumForValue(int value) {
        return map.get(value);
    }

    public static Boolean isDefined(int value) {
        return map.containsKey(value);
    }
}

