/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAddress;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagObjectIdentifier;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetAddressBinding
implements Message {
    protected final BACnetApplicationTagObjectIdentifier deviceIdentifier;
    protected final BACnetAddress deviceAddress;

    public BACnetAddressBinding(BACnetApplicationTagObjectIdentifier deviceIdentifier, BACnetAddress deviceAddress) {
        this.deviceIdentifier = deviceIdentifier;
        this.deviceAddress = deviceAddress;
    }

    public BACnetApplicationTagObjectIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public BACnetAddress getDeviceAddress() {
        return this.deviceAddress;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetAddressBinding", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"deviceIdentifier", (Object)this.deviceIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"deviceAddress", (Object)this.deviceAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetAddressBinding", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetAddressBinding _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.deviceIdentifier.getLengthInBits();
        return lengthInBits += this.deviceAddress.getLengthInBits();
    }

    public static BACnetAddressBinding staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetAddressBinding.staticParse(readBuffer);
    }

    public static BACnetAddressBinding staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetAddressBinding", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagObjectIdentifier deviceIdentifier = (BACnetApplicationTagObjectIdentifier)FieldReaderFactory.readSimpleField((String)"deviceIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagObjectIdentifier)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetAddress deviceAddress = (BACnetAddress)FieldReaderFactory.readSimpleField((String)"deviceAddress", (DataReader)new DataReaderComplexDefault(() -> BACnetAddress.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetAddressBinding", new WithReaderArgs[0]);
        BACnetAddressBinding _bACnetAddressBinding = new BACnetAddressBinding(deviceIdentifier, deviceAddress);
        return _bACnetAddressBinding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetAddressBinding)) {
            return false;
        }
        BACnetAddressBinding that = (BACnetAddressBinding)o;
        return this.getDeviceIdentifier() == that.getDeviceIdentifier() && this.getDeviceAddress() == that.getDeviceAddress();
    }

    public int hashCode() {
        return Objects.hash(this.getDeviceIdentifier(), this.getDeviceAddress());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

