/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetCalendarEntryDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetCalendarEntryDateRange;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetCalendarEntryWeekNDay;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class BACnetCalendarEntry
implements Message {
    protected final BACnetTagHeader peekedTagHeader;

    public BACnetCalendarEntry(BACnetTagHeader peekedTagHeader) {
        this.peekedTagHeader = peekedTagHeader;
    }

    public BACnetTagHeader getPeekedTagHeader() {
        return this.peekedTagHeader;
    }

    public short getPeekedTagNumber() {
        return this.getPeekedTagHeader().getActualTagNumber();
    }

    protected abstract void serializeBACnetCalendarEntryChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetCalendarEntry", new WithWriterArgs[0]);
        short peekedTagNumber = this.getPeekedTagNumber();
        writeBuffer.writeVirtual("peekedTagNumber", (Object)peekedTagNumber, new WithWriterArgs[0]);
        this.serializeBACnetCalendarEntryChild(writeBuffer);
        writeBuffer.popContext("BACnetCalendarEntry", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetCalendarEntry _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static BACnetCalendarEntry staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetCalendarEntry.staticParse(readBuffer);
    }

    public static BACnetCalendarEntry staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetCalendarEntry", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader peekedTagHeader = (BACnetTagHeader)FieldReaderFactory.readPeekField((String)"peekedTagHeader", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short peekedTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"peekedTagNumber", Short.TYPE, (Object)peekedTagHeader.getActualTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        if (peekedTagHeader.getTagClass() != TagClass.CONTEXT_SPECIFIC_TAGS) {
            throw new ParseValidationException("Validation failed");
        }
        BACnetCalendarEntryBuilder builder = null;
        if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)0)) {
            builder = BACnetCalendarEntryDate.staticParseBACnetCalendarEntryBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)1)) {
            builder = BACnetCalendarEntryDateRange.staticParseBACnetCalendarEntryBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)2)) {
            builder = BACnetCalendarEntryWeekNDay.staticParseBACnetCalendarEntryBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [peekedTagNumber=" + peekedTagNumber + "]");
        }
        readBuffer.closeContext("BACnetCalendarEntry", new WithReaderArgs[0]);
        BACnetCalendarEntry _bACnetCalendarEntry = builder.build(peekedTagHeader);
        return _bACnetCalendarEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetCalendarEntry)) {
            return false;
        }
        BACnetCalendarEntry that = (BACnetCalendarEntry)o;
        return this.getPeekedTagHeader() == that.getPeekedTagHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getPeekedTagHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface BACnetCalendarEntryBuilder {
        public BACnetCalendarEntry build(BACnetTagHeader var1);
    }
}

