/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueLightingCommand;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueNull;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueObjectidentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetChannelValueUnsigned;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class BACnetChannelValue
implements Message {
    protected final BACnetTagHeader peekedTagHeader;

    public BACnetChannelValue(BACnetTagHeader peekedTagHeader) {
        this.peekedTagHeader = peekedTagHeader;
    }

    public BACnetTagHeader getPeekedTagHeader() {
        return this.peekedTagHeader;
    }

    public short getPeekedTagNumber() {
        return this.getPeekedTagHeader().getActualTagNumber();
    }

    public boolean getPeekedIsContextTag() {
        return this.getPeekedTagHeader().getTagClass() == TagClass.CONTEXT_SPECIFIC_TAGS;
    }

    protected abstract void serializeBACnetChannelValueChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetChannelValue", new WithWriterArgs[0]);
        short peekedTagNumber = this.getPeekedTagNumber();
        writeBuffer.writeVirtual("peekedTagNumber", (Object)peekedTagNumber, new WithWriterArgs[0]);
        boolean peekedIsContextTag = this.getPeekedIsContextTag();
        writeBuffer.writeVirtual("peekedIsContextTag", (Object)peekedIsContextTag, new WithWriterArgs[0]);
        this.serializeBACnetChannelValueChild(writeBuffer);
        writeBuffer.popContext("BACnetChannelValue", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetChannelValue _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static BACnetChannelValue staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetChannelValue.staticParse(readBuffer);
    }

    public static BACnetChannelValue staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetChannelValue", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader peekedTagHeader = (BACnetTagHeader)FieldReaderFactory.readPeekField((String)"peekedTagHeader", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short peekedTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"peekedTagNumber", Short.TYPE, (Object)peekedTagHeader.getActualTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean peekedIsContextTag = (Boolean)FieldReaderFactory.readVirtualField((String)"peekedIsContextTag", Boolean.TYPE, (Object)(peekedTagHeader.getTagClass() == TagClass.CONTEXT_SPECIFIC_TAGS ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        if (peekedIsContextTag && (!peekedIsContextTag || peekedTagHeader.getLengthValueType() == 6 || peekedTagHeader.getLengthValueType() == 7)) {
            throw new ParseValidationException("unexpected opening or closing tag");
        }
        BACnetChannelValueBuilder builder = null;
        if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)0) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueNull.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)4) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueReal.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)9) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueEnumerated.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)2) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueUnsigned.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)1) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueBoolean.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)3) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueInteger.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)5) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueDouble.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)11) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueTime.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)7) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueCharacterString.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)6) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueOctetString.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)8) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueBitString.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)10) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueDate.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)12) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetChannelValueObjectidentifier.staticParseBACnetChannelValueBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)0) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)true)) {
            builder = BACnetChannelValueLightingCommand.staticParseBACnetChannelValueBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [peekedTagNumber=" + peekedTagNumber + " " + "peekedIsContextTag=" + peekedIsContextTag + "]");
        }
        readBuffer.closeContext("BACnetChannelValue", new WithReaderArgs[0]);
        BACnetChannelValue _bACnetChannelValue = builder.build(peekedTagHeader);
        return _bACnetChannelValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetChannelValue)) {
            return false;
        }
        BACnetChannelValue that = (BACnetChannelValue)o;
        return this.getPeekedTagHeader() == that.getPeekedTagHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getPeekedTagHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface BACnetChannelValueBuilder {
        public BACnetChannelValue build(BACnetTagHeader var1);
    }
}

