/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestCreateObjectObjectSpecifier
implements Message {
    protected final BACnetOpeningTag openingTag;
    protected final BACnetContextTagEnumerated rawObjectType;
    protected final BACnetContextTagObjectIdentifier objectIdentifier;
    protected final BACnetClosingTag closingTag;
    protected final Short tagNumber;

    public BACnetConfirmedServiceRequestCreateObjectObjectSpecifier(BACnetOpeningTag openingTag, BACnetContextTagEnumerated rawObjectType, BACnetContextTagObjectIdentifier objectIdentifier, BACnetClosingTag closingTag, Short tagNumber) {
        this.openingTag = openingTag;
        this.rawObjectType = rawObjectType;
        this.objectIdentifier = objectIdentifier;
        this.closingTag = closingTag;
        this.tagNumber = tagNumber;
    }

    public BACnetOpeningTag getOpeningTag() {
        return this.openingTag;
    }

    public BACnetContextTagEnumerated getRawObjectType() {
        return this.rawObjectType;
    }

    public BACnetContextTagObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public BACnetClosingTag getClosingTag() {
        return this.closingTag;
    }

    public boolean getIsObjectType() {
        return this.getRawObjectType() != null;
    }

    public BACnetObjectType getObjectType() {
        return StaticHelper.mapBACnetObjectType(this.getRawObjectType());
    }

    public boolean getIsObjectIdentifier() {
        return this.getObjectIdentifier() != null;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestCreateObjectObjectSpecifier", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"openingTag", (Object)this.openingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"rawObjectType", (Object)this.rawObjectType, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isObjectType = this.getIsObjectType();
        writeBuffer.writeVirtual("isObjectType", (Object)isObjectType, new WithWriterArgs[0]);
        BACnetObjectType objectType = this.getObjectType();
        writeBuffer.writeVirtual("objectType", (Object)objectType, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"objectIdentifier", (Object)this.objectIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isObjectIdentifier = this.getIsObjectIdentifier();
        writeBuffer.writeVirtual("isObjectIdentifier", (Object)isObjectIdentifier, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"closingTag", (Object)this.closingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestCreateObjectObjectSpecifier", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetConfirmedServiceRequestCreateObjectObjectSpecifier _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.openingTag.getLengthInBits();
        if (this.rawObjectType != null) {
            lengthInBits += this.rawObjectType.getLengthInBits();
        }
        if (this.objectIdentifier != null) {
            lengthInBits += this.objectIdentifier.getLengthInBits();
        }
        return lengthInBits += this.closingTag.getLengthInBits();
    }

    public static BACnetConfirmedServiceRequestCreateObjectObjectSpecifier staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetConfirmedServiceRequestCreateObjectObjectSpecifier.staticParse(readBuffer, tagNumber);
    }

    public static BACnetConfirmedServiceRequestCreateObjectObjectSpecifier staticParse(ReadBuffer readBuffer, Short tagNumber) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestCreateObjectObjectSpecifier", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetOpeningTag openingTag = (BACnetOpeningTag)FieldReaderFactory.readSimpleField((String)"openingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)tagNumber), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagEnumerated rawObjectType = (BACnetContextTagEnumerated)FieldReaderFactory.readOptionalField((String)"rawObjectType", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagEnumerated)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.ENUMERATED), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isObjectType = (Boolean)FieldReaderFactory.readVirtualField((String)"isObjectType", Boolean.TYPE, (Object)(rawObjectType != null ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetObjectType objectType = (BACnetObjectType)((Object)FieldReaderFactory.readVirtualField((String)"objectType", BACnetObjectType.class, (Object)((Object)StaticHelper.mapBACnetObjectType(rawObjectType)), (WithReaderArgs[])new WithReaderArgs[0]));
        BACnetContextTagObjectIdentifier objectIdentifier = (BACnetContextTagObjectIdentifier)FieldReaderFactory.readOptionalField((String)"objectIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagObjectIdentifier)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.BACNET_OBJECT_IDENTIFIER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isObjectIdentifier = (Boolean)FieldReaderFactory.readVirtualField((String)"isObjectIdentifier", Boolean.TYPE, (Object)(objectIdentifier != null ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        if (!isObjectType && !isObjectIdentifier) {
            throw new ParseValidationException("either we need a objectType or a objectIdentifier");
        }
        BACnetClosingTag closingTag = (BACnetClosingTag)FieldReaderFactory.readSimpleField((String)"closingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)tagNumber), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestCreateObjectObjectSpecifier", new WithReaderArgs[0]);
        BACnetConfirmedServiceRequestCreateObjectObjectSpecifier _bACnetConfirmedServiceRequestCreateObjectObjectSpecifier = new BACnetConfirmedServiceRequestCreateObjectObjectSpecifier(openingTag, rawObjectType, objectIdentifier, closingTag, tagNumber);
        return _bACnetConfirmedServiceRequestCreateObjectObjectSpecifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestCreateObjectObjectSpecifier)) {
            return false;
        }
        BACnetConfirmedServiceRequestCreateObjectObjectSpecifier that = (BACnetConfirmedServiceRequestCreateObjectObjectSpecifier)o;
        return this.getOpeningTag() == that.getOpeningTag() && this.getRawObjectType() == that.getRawObjectType() && this.getObjectIdentifier() == that.getObjectIdentifier() && this.getClosingTag() == that.getClosingTag();
    }

    public int hashCode() {
        return Objects.hash(this.getOpeningTag(), this.getRawObjectType(), this.getObjectIdentifier(), this.getClosingTag());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

