/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetWriteAccessSpecification;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestWritePropertyMultiple
extends BACnetConfirmedServiceRequest
implements Message {
    protected final List<BACnetWriteAccessSpecification> data;
    protected final Long serviceRequestPayloadLength;
    protected final Long serviceRequestLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.WRITE_PROPERTY_MULTIPLE;
    }

    public BACnetConfirmedServiceRequestWritePropertyMultiple(List<BACnetWriteAccessSpecification> data, Long serviceRequestPayloadLength, Long serviceRequestLength) {
        super(serviceRequestLength);
        this.data = data;
        this.serviceRequestPayloadLength = serviceRequestPayloadLength;
        this.serviceRequestLength = serviceRequestLength;
    }

    public List<BACnetWriteAccessSpecification> getData() {
        return this.data;
    }

    @Override
    protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestWritePropertyMultiple", new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"data", this.data, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestWritePropertyMultiple", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConfirmedServiceRequestWritePropertyMultiple _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.data != null) {
            for (Message message : this.data) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder staticParseBACnetConfirmedServiceRequestBuilder(ReadBuffer readBuffer, Long serviceRequestPayloadLength, Long serviceRequestLength) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestWritePropertyMultiple", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        List data = FieldReaderFactory.readLengthArrayField((String)"data", (DataReader)new DataReaderComplexDefault(() -> BACnetWriteAccessSpecification.staticParse(readBuffer), readBuffer), (long)serviceRequestPayloadLength, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestWritePropertyMultiple", new WithReaderArgs[0]);
        return new BACnetConfirmedServiceRequestWritePropertyMultipleBuilderImpl(data, serviceRequestPayloadLength, serviceRequestLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestWritePropertyMultiple)) {
            return false;
        }
        BACnetConfirmedServiceRequestWritePropertyMultiple that = (BACnetConfirmedServiceRequestWritePropertyMultiple)o;
        return this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConfirmedServiceRequestWritePropertyMultipleBuilderImpl
    implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
        private final List<BACnetWriteAccessSpecification> data;
        private final Long serviceRequestPayloadLength;
        private final Long serviceRequestLength;

        public BACnetConfirmedServiceRequestWritePropertyMultipleBuilderImpl(List<BACnetWriteAccessSpecification> data, Long serviceRequestPayloadLength, Long serviceRequestLength) {
            this.data = data;
            this.serviceRequestPayloadLength = serviceRequestPayloadLength;
            this.serviceRequestLength = serviceRequestLength;
        }

        @Override
        public BACnetConfirmedServiceRequestWritePropertyMultiple build(Long serviceRequestLength) {
            BACnetConfirmedServiceRequestWritePropertyMultiple bACnetConfirmedServiceRequestWritePropertyMultiple = new BACnetConfirmedServiceRequestWritePropertyMultiple(this.data, this.serviceRequestPayloadLength, serviceRequestLength);
            return bACnetConfirmedServiceRequestWritePropertyMultiple;
        }
    }
}

