/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLifeSafetyModeTagged;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataAcceptedModes
extends BACnetConstructedData
implements Message {
    protected final List<BACnetLifeSafetyModeTagged> acceptedModes;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.ACCEPTED_MODES;
    }

    public BACnetConstructedDataAcceptedModes(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, List<BACnetLifeSafetyModeTagged> acceptedModes, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.acceptedModes = acceptedModes;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public List<BACnetLifeSafetyModeTagged> getAcceptedModes() {
        return this.acceptedModes;
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataAcceptedModes", new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"acceptedModes", this.acceptedModes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataAcceptedModes", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataAcceptedModes _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.acceptedModes != null) {
            for (Message message : this.acceptedModes) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataAcceptedModes", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        List acceptedModes = FieldReaderFactory.readTerminatedArrayField((String)"acceptedModes", (DataReader)new DataReaderComplexDefault(() -> BACnetLifeSafetyModeTagged.staticParse(readBuffer, (short)0, TagClass.APPLICATION_TAGS), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber.shortValue()), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConstructedDataAcceptedModes", new WithReaderArgs[0]);
        return new BACnetConstructedDataAcceptedModesBuilderImpl(acceptedModes, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataAcceptedModes)) {
            return false;
        }
        BACnetConstructedDataAcceptedModes that = (BACnetConstructedDataAcceptedModes)o;
        return this.getAcceptedModes() == that.getAcceptedModes() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAcceptedModes());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataAcceptedModesBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final List<BACnetLifeSafetyModeTagged> acceptedModes;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataAcceptedModesBuilderImpl(List<BACnetLifeSafetyModeTagged> acceptedModes, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.acceptedModes = acceptedModes;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataAcceptedModes build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataAcceptedModes bACnetConstructedDataAcceptedModes = new BACnetConstructedDataAcceptedModes(openingTag, peekedTagHeader, closingTag, this.acceptedModes, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataAcceptedModes;
        }
    }
}

