/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTimeStamp;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataCommandTimeArray
extends BACnetConstructedData
implements Message {
    protected final BACnetApplicationTagUnsignedInteger numberOfDataElements;
    protected final List<BACnetTimeStamp> commandTimeArray;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.COMMAND_TIME_ARRAY;
    }

    public BACnetConstructedDataCommandTimeArray(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, BACnetApplicationTagUnsignedInteger numberOfDataElements, List<BACnetTimeStamp> commandTimeArray, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.numberOfDataElements = numberOfDataElements;
        this.commandTimeArray = commandTimeArray;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetApplicationTagUnsignedInteger getNumberOfDataElements() {
        return this.numberOfDataElements;
    }

    public List<BACnetTimeStamp> getCommandTimeArray() {
        return this.commandTimeArray;
    }

    public BigInteger getZero() {
        Long o = 0L;
        if (o instanceof BigInteger) {
            return (BigInteger)((Object)o);
        }
        return BigInteger.valueOf(((Number)o).longValue());
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataCommandTimeArray", new WithWriterArgs[0]);
        BigInteger zero = this.getZero();
        writeBuffer.writeVirtual("zero", (Object)zero, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"numberOfDataElements", (Object)this.numberOfDataElements, (DataWriter)new DataWriterComplexDefault(writeBuffer), (this.arrayIndexArgument != null && this.arrayIndexArgument.getActualValue() == this.getZero() ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"commandTimeArray", this.commandTimeArray, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataCommandTimeArray", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataCommandTimeArray _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.numberOfDataElements != null) {
            lengthInBits += this.numberOfDataElements.getLengthInBits();
        }
        if (this.commandTimeArray != null) {
            for (Message message : this.commandTimeArray) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataCommandTimeArray", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BigInteger zero = (BigInteger)FieldReaderFactory.readVirtualField((String)"zero", BigInteger.class, (Object)0L, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagUnsignedInteger numberOfDataElements = (BACnetApplicationTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"numberOfDataElements", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (arrayIndexArgument != null && arrayIndexArgument.getActualValue() == zero ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        List commandTimeArray = FieldReaderFactory.readTerminatedArrayField((String)"commandTimeArray", (DataReader)new DataReaderComplexDefault(() -> BACnetTimeStamp.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber.shortValue()), (WithReaderArgs[])new WithReaderArgs[0]);
        if (arrayIndexArgument == null && org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)commandTimeArray) != 16) {
            throw new ParseValidationException("commandTimeArray should have exactly 16 values");
        }
        readBuffer.closeContext("BACnetConstructedDataCommandTimeArray", new WithReaderArgs[0]);
        return new BACnetConstructedDataCommandTimeArrayBuilderImpl(numberOfDataElements, commandTimeArray, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataCommandTimeArray)) {
            return false;
        }
        BACnetConstructedDataCommandTimeArray that = (BACnetConstructedDataCommandTimeArray)o;
        return this.getNumberOfDataElements() == that.getNumberOfDataElements() && this.getCommandTimeArray() == that.getCommandTimeArray() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumberOfDataElements(), this.getCommandTimeArray());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataCommandTimeArrayBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final BACnetApplicationTagUnsignedInteger numberOfDataElements;
        private final List<BACnetTimeStamp> commandTimeArray;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataCommandTimeArrayBuilderImpl(BACnetApplicationTagUnsignedInteger numberOfDataElements, List<BACnetTimeStamp> commandTimeArray, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.numberOfDataElements = numberOfDataElements;
            this.commandTimeArray = commandTimeArray;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataCommandTimeArray build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataCommandTimeArray bACnetConstructedDataCommandTimeArray = new BACnetConstructedDataCommandTimeArray(openingTag, peekedTagHeader, closingTag, this.numberOfDataElements, this.commandTimeArray, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataCommandTimeArray;
        }
    }
}

