/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataElement
implements Message {
    protected final BACnetTagHeader peekedTagHeader;
    protected final BACnetApplicationTag applicationTag;
    protected final BACnetContextTag contextTag;
    protected final BACnetConstructedData constructedData;
    protected final BACnetObjectType objectTypeArgument;
    protected final BACnetPropertyIdentifier propertyIdentifierArgument;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    public BACnetConstructedDataElement(BACnetTagHeader peekedTagHeader, BACnetApplicationTag applicationTag, BACnetContextTag contextTag, BACnetConstructedData constructedData, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        this.peekedTagHeader = peekedTagHeader;
        this.applicationTag = applicationTag;
        this.contextTag = contextTag;
        this.constructedData = constructedData;
        this.objectTypeArgument = objectTypeArgument;
        this.propertyIdentifierArgument = propertyIdentifierArgument;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetTagHeader getPeekedTagHeader() {
        return this.peekedTagHeader;
    }

    public BACnetApplicationTag getApplicationTag() {
        return this.applicationTag;
    }

    public BACnetContextTag getContextTag() {
        return this.contextTag;
    }

    public BACnetConstructedData getConstructedData() {
        return this.constructedData;
    }

    public short getPeekedTagNumber() {
        return this.getPeekedTagHeader().getActualTagNumber();
    }

    public boolean getIsApplicationTag() {
        return this.getPeekedTagHeader().getTagClass() == TagClass.APPLICATION_TAGS;
    }

    public boolean getIsConstructedData() {
        return !this.getIsApplicationTag() && this.getPeekedTagHeader().getLengthValueType() == 6;
    }

    public boolean getIsContextTag() {
        return !this.getIsConstructedData() && !this.getIsApplicationTag();
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataElement", new WithWriterArgs[0]);
        short peekedTagNumber = this.getPeekedTagNumber();
        writeBuffer.writeVirtual("peekedTagNumber", (Object)peekedTagNumber, new WithWriterArgs[0]);
        boolean isApplicationTag = this.getIsApplicationTag();
        writeBuffer.writeVirtual("isApplicationTag", (Object)isApplicationTag, new WithWriterArgs[0]);
        boolean isConstructedData = this.getIsConstructedData();
        writeBuffer.writeVirtual("isConstructedData", (Object)isConstructedData, new WithWriterArgs[0]);
        boolean isContextTag = this.getIsContextTag();
        writeBuffer.writeVirtual("isContextTag", (Object)isContextTag, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"applicationTag", (Object)this.applicationTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (boolean)this.getIsApplicationTag(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"contextTag", (Object)this.contextTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (boolean)this.getIsContextTag(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"constructedData", (Object)this.constructedData, (DataWriter)new DataWriterComplexDefault(writeBuffer), (boolean)this.getIsConstructedData(), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataElement", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetConstructedDataElement _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.applicationTag != null) {
            lengthInBits += this.applicationTag.getLengthInBits();
        }
        if (this.contextTag != null) {
            lengthInBits += this.contextTag.getLengthInBits();
        }
        if (this.constructedData != null) {
            lengthInBits += this.constructedData.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetConstructedDataElement staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        BACnetPropertyIdentifier propertyIdentifierArgument;
        BACnetObjectType objectTypeArgument;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 3) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 3, but got " + args.length);
        }
        if (args[0] instanceof BACnetObjectType) {
            objectTypeArgument = (BACnetObjectType)((Object)args[0]);
        } else if (args[0] instanceof String) {
            objectTypeArgument = BACnetObjectType.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type BACnetObjectType or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof BACnetPropertyIdentifier) {
            propertyIdentifierArgument = (BACnetPropertyIdentifier)((Object)args[1]);
        } else if (args[1] instanceof String) {
            propertyIdentifierArgument = BACnetPropertyIdentifier.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type BACnetPropertyIdentifier or a string which is parseable but was " + args[1].getClass().getName());
        }
        if (!(args[2] instanceof BACnetTagPayloadUnsignedInteger)) {
            throw new PlcRuntimeException("Argument 2 expected to be of type BACnetTagPayloadUnsignedInteger or a string which is parseable but was " + args[2].getClass().getName());
        }
        BACnetTagPayloadUnsignedInteger arrayIndexArgument = (BACnetTagPayloadUnsignedInteger)args[2];
        return BACnetConstructedDataElement.staticParse(readBuffer, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument);
    }

    public static BACnetConstructedDataElement staticParse(ReadBuffer readBuffer, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataElement", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader peekedTagHeader = (BACnetTagHeader)FieldReaderFactory.readPeekField((String)"peekedTagHeader", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short peekedTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"peekedTagNumber", Short.TYPE, (Object)peekedTagHeader.getActualTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isApplicationTag = (Boolean)FieldReaderFactory.readVirtualField((String)"isApplicationTag", Boolean.TYPE, (Object)(peekedTagHeader.getTagClass() == TagClass.APPLICATION_TAGS ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isConstructedData = (Boolean)FieldReaderFactory.readVirtualField((String)"isConstructedData", Boolean.TYPE, (Object)(!isApplicationTag && peekedTagHeader.getLengthValueType() == 6 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isContextTag = (Boolean)FieldReaderFactory.readVirtualField((String)"isContextTag", Boolean.TYPE, (Object)(!isConstructedData && !isApplicationTag ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        if (isContextTag && (!isContextTag || peekedTagHeader.getLengthValueType() == 7)) {
            throw new ParseValidationException("unexpected closing tag");
        }
        BACnetApplicationTag applicationTag = (BACnetApplicationTag)FieldReaderFactory.readOptionalField((String)"applicationTag", (DataReader)new DataReaderComplexDefault(() -> BACnetApplicationTag.staticParse(readBuffer), readBuffer), (boolean)isApplicationTag, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTag contextTag = (BACnetContextTag)FieldReaderFactory.readOptionalField((String)"contextTag", (DataReader)new DataReaderComplexDefault(() -> BACnetContextTag.staticParse(readBuffer, peekedTagNumber, BACnetDataType.UNKNOWN), readBuffer), (boolean)isContextTag, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConstructedData constructedData = (BACnetConstructedData)FieldReaderFactory.readOptionalField((String)"constructedData", (DataReader)new DataReaderComplexDefault(() -> BACnetConstructedData.staticParse(readBuffer, peekedTagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument), readBuffer), (boolean)isConstructedData, (WithReaderArgs[])new WithReaderArgs[0]);
        if (!(isApplicationTag && applicationTag != null || isContextTag && contextTag != null || isConstructedData && constructedData != null)) {
            throw new ParseValidationException("BACnetConstructedDataElement could not parse anything");
        }
        readBuffer.closeContext("BACnetConstructedDataElement", new WithReaderArgs[0]);
        BACnetConstructedDataElement _bACnetConstructedDataElement = new BACnetConstructedDataElement(peekedTagHeader, applicationTag, contextTag, constructedData, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument);
        return _bACnetConstructedDataElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataElement)) {
            return false;
        }
        BACnetConstructedDataElement that = (BACnetConstructedDataElement)o;
        return this.getPeekedTagHeader() == that.getPeekedTagHeader() && this.getApplicationTag() == that.getApplicationTag() && this.getContextTag() == that.getContextTag() && this.getConstructedData() == that.getConstructedData();
    }

    public int hashCode() {
        return Objects.hash(this.getPeekedTagHeader(), this.getApplicationTag(), this.getContextTag(), this.getConstructedData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

