/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum BACnetDataType {
    NULL(0),
    BOOLEAN(1),
    UNSIGNED_INTEGER(2),
    SIGNED_INTEGER(3),
    REAL(4),
    DOUBLE(5),
    OCTET_STRING(6),
    CHARACTER_STRING(7),
    BIT_STRING(8),
    ENUMERATED(9),
    DATE(10),
    TIME(11),
    BACNET_OBJECT_IDENTIFIER(12),
    UNKNOWN(33);

    private static final Map<Short, BACnetDataType> map;
    private final short value;

    static {
        map = new HashMap<Short, BACnetDataType>();
        BACnetDataType[] bACnetDataTypeArray = BACnetDataType.values();
        int n = bACnetDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BACnetDataType value = bACnetDataTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private BACnetDataType(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static BACnetDataType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

