/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLightingOperationTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetLightingCommand
implements Message {
    protected final BACnetLightingOperationTagged lightningOperation;
    protected final BACnetContextTagReal targetLevel;
    protected final BACnetContextTagReal rampRate;
    protected final BACnetContextTagReal stepIncrement;
    protected final BACnetContextTagUnsignedInteger fadeTime;
    protected final BACnetContextTagUnsignedInteger priority;

    public BACnetLightingCommand(BACnetLightingOperationTagged lightningOperation, BACnetContextTagReal targetLevel, BACnetContextTagReal rampRate, BACnetContextTagReal stepIncrement, BACnetContextTagUnsignedInteger fadeTime, BACnetContextTagUnsignedInteger priority) {
        this.lightningOperation = lightningOperation;
        this.targetLevel = targetLevel;
        this.rampRate = rampRate;
        this.stepIncrement = stepIncrement;
        this.fadeTime = fadeTime;
        this.priority = priority;
    }

    public BACnetLightingOperationTagged getLightningOperation() {
        return this.lightningOperation;
    }

    public BACnetContextTagReal getTargetLevel() {
        return this.targetLevel;
    }

    public BACnetContextTagReal getRampRate() {
        return this.rampRate;
    }

    public BACnetContextTagReal getStepIncrement() {
        return this.stepIncrement;
    }

    public BACnetContextTagUnsignedInteger getFadeTime() {
        return this.fadeTime;
    }

    public BACnetContextTagUnsignedInteger getPriority() {
        return this.priority;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetLightingCommand", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"lightningOperation", (Object)this.lightningOperation, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"targetLevel", (Object)this.targetLevel, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"rampRate", (Object)this.rampRate, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"stepIncrement", (Object)this.stepIncrement, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"fadeTime", (Object)this.fadeTime, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"priority", (Object)this.priority, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetLightingCommand", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetLightingCommand _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.lightningOperation.getLengthInBits();
        if (this.targetLevel != null) {
            lengthInBits += this.targetLevel.getLengthInBits();
        }
        if (this.rampRate != null) {
            lengthInBits += this.rampRate.getLengthInBits();
        }
        if (this.stepIncrement != null) {
            lengthInBits += this.stepIncrement.getLengthInBits();
        }
        if (this.fadeTime != null) {
            lengthInBits += this.fadeTime.getLengthInBits();
        }
        if (this.priority != null) {
            lengthInBits += this.priority.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetLightingCommand staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetLightingCommand.staticParse(readBuffer);
    }

    public static BACnetLightingCommand staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetLightingCommand", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetLightingOperationTagged lightningOperation = (BACnetLightingOperationTagged)FieldReaderFactory.readSimpleField((String)"lightningOperation", (DataReader)new DataReaderComplexDefault(() -> BACnetLightingOperationTagged.staticParse(readBuffer, (short)0, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagReal targetLevel = (BACnetContextTagReal)FieldReaderFactory.readOptionalField((String)"targetLevel", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagReal)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.REAL), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagReal rampRate = (BACnetContextTagReal)FieldReaderFactory.readOptionalField((String)"rampRate", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagReal)BACnetContextTag.staticParse(readBuffer, (short)2, BACnetDataType.REAL), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagReal stepIncrement = (BACnetContextTagReal)FieldReaderFactory.readOptionalField((String)"stepIncrement", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagReal)BACnetContextTag.staticParse(readBuffer, (short)3, BACnetDataType.REAL), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger fadeTime = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"fadeTime", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)4, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger priority = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"priority", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)5, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetLightingCommand", new WithReaderArgs[0]);
        BACnetLightingCommand _bACnetLightingCommand = new BACnetLightingCommand(lightningOperation, targetLevel, rampRate, stepIncrement, fadeTime, priority);
        return _bACnetLightingCommand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetLightingCommand)) {
            return false;
        }
        BACnetLightingCommand that = (BACnetLightingCommand)o;
        return this.getLightningOperation() == that.getLightningOperation() && this.getTargetLevel() == that.getTargetLevel() && this.getRampRate() == that.getRampRate() && this.getStepIncrement() == that.getStepIncrement() && this.getFadeTime() == that.getFadeTime() && this.getPriority() == that.getPriority();
    }

    public int hashCode() {
        return Objects.hash(this.getLightningOperation(), this.getTargetLevel(), this.getRampRate(), this.getStepIncrement(), this.getFadeTime(), this.getPriority());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

