/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDateTimeEnclosed;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLogRecordLogDatum;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetStatusFlagsTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetLogRecord
implements Message {
    protected final BACnetDateTimeEnclosed timestamp;
    protected final BACnetLogRecordLogDatum logDatum;
    protected final BACnetStatusFlagsTagged statusFlags;

    public BACnetLogRecord(BACnetDateTimeEnclosed timestamp, BACnetLogRecordLogDatum logDatum, BACnetStatusFlagsTagged statusFlags) {
        this.timestamp = timestamp;
        this.logDatum = logDatum;
        this.statusFlags = statusFlags;
    }

    public BACnetDateTimeEnclosed getTimestamp() {
        return this.timestamp;
    }

    public BACnetLogRecordLogDatum getLogDatum() {
        return this.logDatum;
    }

    public BACnetStatusFlagsTagged getStatusFlags() {
        return this.statusFlags;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetLogRecord", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timestamp", (Object)this.timestamp, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"logDatum", (Object)this.logDatum, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"statusFlags", (Object)this.statusFlags, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetLogRecord", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetLogRecord _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.timestamp.getLengthInBits();
        lengthInBits += this.logDatum.getLengthInBits();
        if (this.statusFlags != null) {
            lengthInBits += this.statusFlags.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetLogRecord staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetLogRecord.staticParse(readBuffer);
    }

    public static BACnetLogRecord staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetLogRecord", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetDateTimeEnclosed timestamp = (BACnetDateTimeEnclosed)FieldReaderFactory.readSimpleField((String)"timestamp", (DataReader)new DataReaderComplexDefault(() -> BACnetDateTimeEnclosed.staticParse(readBuffer, (short)0), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetLogRecordLogDatum logDatum = (BACnetLogRecordLogDatum)FieldReaderFactory.readSimpleField((String)"logDatum", (DataReader)new DataReaderComplexDefault(() -> BACnetLogRecordLogDatum.staticParse(readBuffer, (short)1), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetStatusFlagsTagged statusFlags = (BACnetStatusFlagsTagged)FieldReaderFactory.readOptionalField((String)"statusFlags", (DataReader)new DataReaderComplexDefault(() -> BACnetStatusFlagsTagged.staticParse(readBuffer, (short)2, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetLogRecord", new WithReaderArgs[0]);
        BACnetLogRecord _bACnetLogRecord = new BACnetLogRecord(timestamp, logDatum, statusFlags);
        return _bACnetLogRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetLogRecord)) {
            return false;
        }
        BACnetLogRecord that = (BACnetLogRecord)o;
        return this.getTimestamp() == that.getTimestamp() && this.getLogDatum() == that.getLogDatum() && this.getStatusFlags() == that.getStatusFlags();
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamp(), this.getLogDatum(), this.getStatusFlags());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

