/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetNameValue
implements Message {
    protected final BACnetContextTagCharacterString name;
    protected final BACnetConstructedData value;

    public BACnetNameValue(BACnetContextTagCharacterString name, BACnetConstructedData value) {
        this.name = name;
        this.value = value;
    }

    public BACnetContextTagCharacterString getName() {
        return this.name;
    }

    public BACnetConstructedData getValue() {
        return this.value;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetNameValue", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"value", (Object)this.value, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetNameValue", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetNameValue _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        if (this.value != null) {
            lengthInBits += this.value.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetNameValue staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetNameValue.staticParse(readBuffer);
    }

    public static BACnetNameValue staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetNameValue", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagCharacterString name = (BACnetContextTagCharacterString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagCharacterString)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.CHARACTER_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConstructedData value = (BACnetConstructedData)FieldReaderFactory.readOptionalField((String)"value", (DataReader)new DataReaderComplexDefault(() -> BACnetConstructedData.staticParse(readBuffer, (short)1, BACnetObjectType.VENDOR_PROPRIETARY_VALUE, BACnetPropertyIdentifier.VENDOR_PROPRIETARY_VALUE, null), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetNameValue", new WithReaderArgs[0]);
        BACnetNameValue _bACnetNameValue = new BACnetNameValue(name, value);
        return _bACnetNameValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetNameValue)) {
            return false;
        }
        BACnetNameValue that = (BACnetNameValue)o;
        return this.getName() == that.getName() && this.getValue() == that.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getValue());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

