/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum BACnetObjectType {
    ACCESS_CREDENTIAL(32),
    ACCESS_DOOR(30),
    ACCESS_POINT(33),
    ACCESS_RIGHTS(34),
    ACCESS_USER(35),
    ACCESS_ZONE(36),
    ACCUMULATOR(23),
    ALERT_ENROLLMENT(52),
    ANALOG_INPUT(0),
    ANALOG_OUTPUT(1),
    ANALOG_VALUE(2),
    AVERAGING(18),
    BINARY_INPUT(3),
    BINARY_LIGHTING_OUTPUT(55),
    BINARY_OUTPUT(4),
    BINARY_VALUE(5),
    BITSTRING_VALUE(39),
    CALENDAR(6),
    CHANNEL(53),
    CHARACTERSTRING_VALUE(40),
    COMMAND(7),
    CREDENTIAL_DATA_INPUT(37),
    DATEPATTERN_VALUE(41),
    DATE_VALUE(42),
    DATETIMEPATTERN_VALUE(43),
    DATETIME_VALUE(44),
    DEVICE(8),
    ELEVATOR_GROUP(57),
    ESCALATOR(58),
    EVENT_ENROLLMENT(9),
    EVENT_LOG(25),
    FILE(10),
    GLOBAL_GROUP(26),
    GROUP(11),
    INTEGER_VALUE(45),
    LARGE_ANALOG_VALUE(46),
    LIFE_SAFETY_POINT(21),
    LIFE_SAFETY_ZONE(22),
    LIFT(59),
    LIGHTING_OUTPUT(54),
    LOAD_CONTROL(28),
    LOOP(12),
    MULTI_STATE_INPUT(13),
    MULTI_STATE_OUTPUT(14),
    MULTI_STATE_VALUE(19),
    NETWORK_PORT(56),
    NETWORK_SECURITY(38),
    NOTIFICATION_CLASS(15),
    NOTIFICATION_FORWARDER(51),
    OCTETSTRING_VALUE(47),
    POSITIVE_INTEGER_VALUE(48),
    PROGRAM(16),
    PULSE_CONVERTER(24),
    SCHEDULE(17),
    STRUCTURED_VIEW(29),
    TIMEPATTERN_VALUE(49),
    TIME_VALUE(50),
    TIMER(31),
    TREND_LOG(20),
    TREND_LOG_MULTIPLE(27),
    VENDOR_PROPRIETARY_VALUE(1023);

    private static final Map<Short, BACnetObjectType> map;
    private final short value;

    static {
        map = new HashMap<Short, BACnetObjectType>();
        BACnetObjectType[] bACnetObjectTypeArray = BACnetObjectType.values();
        int n = bACnetObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BACnetObjectType value = bACnetObjectTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private BACnetObjectType(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static BACnetObjectType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

