/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadBitString;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetObjectTypesSupportedTagged
implements Message {
    protected final BACnetTagHeader header;
    protected final BACnetTagPayloadBitString payload;
    protected final Short tagNumber;
    protected final TagClass tagClass;

    public BACnetObjectTypesSupportedTagged(BACnetTagHeader header, BACnetTagPayloadBitString payload, Short tagNumber, TagClass tagClass) {
        this.header = header;
        this.payload = payload;
        this.tagNumber = tagNumber;
        this.tagClass = tagClass;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public BACnetTagPayloadBitString getPayload() {
        return this.payload;
    }

    public boolean getTimeValue() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 0 ? this.getPayload().getData().get(0) : false;
    }

    public boolean getNotificationForwarder() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 1 ? this.getPayload().getData().get(1) : false;
    }

    public boolean getAlertEnrollment() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 2 ? this.getPayload().getData().get(2) : false;
    }

    public boolean getChannel() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 3 ? this.getPayload().getData().get(3) : false;
    }

    public boolean getLightingOutput() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 4 ? this.getPayload().getData().get(4) : false;
    }

    public boolean getBinaryLightingOutput() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 5 ? this.getPayload().getData().get(5) : false;
    }

    public boolean getNetworkPort() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 6 ? this.getPayload().getData().get(6) : false;
    }

    public boolean getElevatorGroup() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 7 ? this.getPayload().getData().get(7) : false;
    }

    public boolean getEscalator() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 8 ? this.getPayload().getData().get(8) : false;
    }

    public boolean getLift() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 9 ? this.getPayload().getData().get(9) : false;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetObjectTypesSupportedTagged", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean timeValue = this.getTimeValue();
        writeBuffer.writeVirtual("timeValue", (Object)timeValue, new WithWriterArgs[0]);
        boolean notificationForwarder = this.getNotificationForwarder();
        writeBuffer.writeVirtual("notificationForwarder", (Object)notificationForwarder, new WithWriterArgs[0]);
        boolean alertEnrollment = this.getAlertEnrollment();
        writeBuffer.writeVirtual("alertEnrollment", (Object)alertEnrollment, new WithWriterArgs[0]);
        boolean channel = this.getChannel();
        writeBuffer.writeVirtual("channel", (Object)channel, new WithWriterArgs[0]);
        boolean lightingOutput = this.getLightingOutput();
        writeBuffer.writeVirtual("lightingOutput", (Object)lightingOutput, new WithWriterArgs[0]);
        boolean binaryLightingOutput = this.getBinaryLightingOutput();
        writeBuffer.writeVirtual("binaryLightingOutput", (Object)binaryLightingOutput, new WithWriterArgs[0]);
        boolean networkPort = this.getNetworkPort();
        writeBuffer.writeVirtual("networkPort", (Object)networkPort, new WithWriterArgs[0]);
        boolean elevatorGroup = this.getElevatorGroup();
        writeBuffer.writeVirtual("elevatorGroup", (Object)elevatorGroup, new WithWriterArgs[0]);
        boolean escalator = this.getEscalator();
        writeBuffer.writeVirtual("escalator", (Object)escalator, new WithWriterArgs[0]);
        boolean lift = this.getLift();
        writeBuffer.writeVirtual("lift", (Object)lift, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetObjectTypesSupportedTagged", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetObjectTypesSupportedTagged _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.header.getLengthInBits();
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static BACnetObjectTypesSupportedTagged staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        TagClass tagClass;
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof TagClass) {
            tagClass = (TagClass)((Object)args[1]);
        } else if (args[1] instanceof String) {
            tagClass = TagClass.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type TagClass or a string which is parseable but was " + args[1].getClass().getName());
        }
        return BACnetObjectTypesSupportedTagged.staticParse(readBuffer, tagNumber, tagClass);
    }

    public static BACnetObjectTypesSupportedTagged staticParse(ReadBuffer readBuffer, Short tagNumber, TagClass tagClass) throws ParseException {
        readBuffer.pullContext("BACnetObjectTypesSupportedTagged", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getTagClass() != tagClass) {
            throw new ParseValidationException("tag class doesn't match");
        }
        if (header.getTagClass() != TagClass.APPLICATION_TAGS && header.getActualTagNumber() != tagNumber.shortValue()) {
            throw new ParseAssertException("tagnumber doesn't match");
        }
        BACnetTagPayloadBitString payload = (BACnetTagPayloadBitString)FieldReaderFactory.readSimpleField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> BACnetTagPayloadBitString.staticParse(readBuffer, header.getActualLength()), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean timeValue = (Boolean)FieldReaderFactory.readVirtualField((String)"timeValue", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 0 ? payload.getData().get(0) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean notificationForwarder = (Boolean)FieldReaderFactory.readVirtualField((String)"notificationForwarder", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 1 ? payload.getData().get(1) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean alertEnrollment = (Boolean)FieldReaderFactory.readVirtualField((String)"alertEnrollment", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 2 ? payload.getData().get(2) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean channel = (Boolean)FieldReaderFactory.readVirtualField((String)"channel", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 3 ? payload.getData().get(3) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean lightingOutput = (Boolean)FieldReaderFactory.readVirtualField((String)"lightingOutput", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 4 ? payload.getData().get(4) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean binaryLightingOutput = (Boolean)FieldReaderFactory.readVirtualField((String)"binaryLightingOutput", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 5 ? payload.getData().get(5) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean networkPort = (Boolean)FieldReaderFactory.readVirtualField((String)"networkPort", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 6 ? payload.getData().get(6) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean elevatorGroup = (Boolean)FieldReaderFactory.readVirtualField((String)"elevatorGroup", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 7 ? payload.getData().get(7) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean escalator = (Boolean)FieldReaderFactory.readVirtualField((String)"escalator", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 8 ? payload.getData().get(8) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean lift = (Boolean)FieldReaderFactory.readVirtualField((String)"lift", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 9 ? payload.getData().get(9) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetObjectTypesSupportedTagged", new WithReaderArgs[0]);
        BACnetObjectTypesSupportedTagged _bACnetObjectTypesSupportedTagged = new BACnetObjectTypesSupportedTagged(header, payload, tagNumber, tagClass);
        return _bACnetObjectTypesSupportedTagged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetObjectTypesSupportedTagged)) {
            return false;
        }
        BACnetObjectTypesSupportedTagged that = (BACnetObjectTypesSupportedTagged)o;
        return this.getHeader() == that.getHeader() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getHeader(), this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

