/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyStates;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetPropertyStatesEnclosed
implements Message {
    protected final BACnetOpeningTag openingTag;
    protected final BACnetPropertyStates propertyState;
    protected final BACnetClosingTag closingTag;
    protected final Short tagNumber;

    public BACnetPropertyStatesEnclosed(BACnetOpeningTag openingTag, BACnetPropertyStates propertyState, BACnetClosingTag closingTag, Short tagNumber) {
        this.openingTag = openingTag;
        this.propertyState = propertyState;
        this.closingTag = closingTag;
        this.tagNumber = tagNumber;
    }

    public BACnetOpeningTag getOpeningTag() {
        return this.openingTag;
    }

    public BACnetPropertyStates getPropertyState() {
        return this.propertyState;
    }

    public BACnetClosingTag getClosingTag() {
        return this.closingTag;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetPropertyStatesEnclosed", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"openingTag", (Object)this.openingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"propertyState", (Object)this.propertyState, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"closingTag", (Object)this.closingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetPropertyStatesEnclosed", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetPropertyStatesEnclosed _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.openingTag.getLengthInBits();
        lengthInBits += this.propertyState.getLengthInBits();
        return lengthInBits += this.closingTag.getLengthInBits();
    }

    public static BACnetPropertyStatesEnclosed staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetPropertyStatesEnclosed.staticParse(readBuffer, tagNumber);
    }

    public static BACnetPropertyStatesEnclosed staticParse(ReadBuffer readBuffer, Short tagNumber) throws ParseException {
        readBuffer.pullContext("BACnetPropertyStatesEnclosed", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetOpeningTag openingTag = (BACnetOpeningTag)FieldReaderFactory.readSimpleField((String)"openingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)tagNumber), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetPropertyStates propertyState = (BACnetPropertyStates)FieldReaderFactory.readSimpleField((String)"propertyState", (DataReader)new DataReaderComplexDefault(() -> BACnetPropertyStates.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetClosingTag closingTag = (BACnetClosingTag)FieldReaderFactory.readSimpleField((String)"closingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)tagNumber), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetPropertyStatesEnclosed", new WithReaderArgs[0]);
        BACnetPropertyStatesEnclosed _bACnetPropertyStatesEnclosed = new BACnetPropertyStatesEnclosed(openingTag, propertyState, closingTag, tagNumber);
        return _bACnetPropertyStatesEnclosed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetPropertyStatesEnclosed)) {
            return false;
        }
        BACnetPropertyStatesEnclosed that = (BACnetPropertyStatesEnclosed)o;
        return this.getOpeningTag() == that.getOpeningTag() && this.getPropertyState() == that.getPropertyState() && this.getClosingTag() == that.getClosingTag();
    }

    public int hashCode() {
        return Objects.hash(this.getOpeningTag(), this.getPropertyState(), this.getClosingTag());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

