/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum BACnetProtocolLevel {
    PHYSICAL(0),
    PROTOCOL(1),
    BACNET_APPLICATION(2),
    NON_BACNET_APPLICATION(3);

    private static final Map<Short, BACnetProtocolLevel> map;
    private final short value;

    static {
        map = new HashMap<Short, BACnetProtocolLevel>();
        BACnetProtocolLevel[] bACnetProtocolLevelArray = BACnetProtocolLevel.values();
        int n = bACnetProtocolLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            BACnetProtocolLevel value = bACnetProtocolLevelArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private BACnetProtocolLevel(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static BACnetProtocolLevel enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

