/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyReference;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetReadAccessSpecification
implements Message {
    protected final BACnetContextTagObjectIdentifier objectIdentifier;
    protected final BACnetOpeningTag openingTag;
    protected final List<BACnetPropertyReference> listOfPropertyReferences;
    protected final BACnetClosingTag closingTag;

    public BACnetReadAccessSpecification(BACnetContextTagObjectIdentifier objectIdentifier, BACnetOpeningTag openingTag, List<BACnetPropertyReference> listOfPropertyReferences, BACnetClosingTag closingTag) {
        this.objectIdentifier = objectIdentifier;
        this.openingTag = openingTag;
        this.listOfPropertyReferences = listOfPropertyReferences;
        this.closingTag = closingTag;
    }

    public BACnetContextTagObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public BACnetOpeningTag getOpeningTag() {
        return this.openingTag;
    }

    public List<BACnetPropertyReference> getListOfPropertyReferences() {
        return this.listOfPropertyReferences;
    }

    public BACnetClosingTag getClosingTag() {
        return this.closingTag;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetReadAccessSpecification", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"objectIdentifier", (Object)this.objectIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"openingTag", (Object)this.openingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"listOfPropertyReferences", this.listOfPropertyReferences, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"closingTag", (Object)this.closingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetReadAccessSpecification", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetReadAccessSpecification _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.objectIdentifier.getLengthInBits();
        lengthInBits += this.openingTag.getLengthInBits();
        if (this.listOfPropertyReferences != null) {
            for (Message message : this.listOfPropertyReferences) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits += this.closingTag.getLengthInBits();
    }

    public static BACnetReadAccessSpecification staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetReadAccessSpecification.staticParse(readBuffer);
    }

    public static BACnetReadAccessSpecification staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetReadAccessSpecification", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagObjectIdentifier objectIdentifier = (BACnetContextTagObjectIdentifier)FieldReaderFactory.readSimpleField((String)"objectIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagObjectIdentifier)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.BACNET_OBJECT_IDENTIFIER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetOpeningTag openingTag = (BACnetOpeningTag)FieldReaderFactory.readSimpleField((String)"openingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)1), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        List listOfPropertyReferences = FieldReaderFactory.readTerminatedArrayField((String)"listOfPropertyReferences", (DataReader)new DataReaderComplexDefault(() -> BACnetPropertyReference.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, 1), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetClosingTag closingTag = (BACnetClosingTag)FieldReaderFactory.readSimpleField((String)"closingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)1), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetReadAccessSpecification", new WithReaderArgs[0]);
        BACnetReadAccessSpecification _bACnetReadAccessSpecification = new BACnetReadAccessSpecification(objectIdentifier, openingTag, listOfPropertyReferences, closingTag);
        return _bACnetReadAccessSpecification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetReadAccessSpecification)) {
            return false;
        }
        BACnetReadAccessSpecification that = (BACnetReadAccessSpecification)o;
        return this.getObjectIdentifier() == that.getObjectIdentifier() && this.getOpeningTag() == that.getOpeningTag() && this.getListOfPropertyReferences() == that.getListOfPropertyReferences() && this.getClosingTag() == that.getClosingTag();
    }

    public int hashCode() {
        return Objects.hash(this.getObjectIdentifier(), this.getOpeningTag(), this.getListOfPropertyReferences(), this.getClosingTag());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

