/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadBitString;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetResultFlagsTagged
implements Message {
    protected final BACnetTagHeader header;
    protected final BACnetTagPayloadBitString payload;
    protected final Short tagNumber;
    protected final TagClass tagClass;

    public BACnetResultFlagsTagged(BACnetTagHeader header, BACnetTagPayloadBitString payload, Short tagNumber, TagClass tagClass) {
        this.header = header;
        this.payload = payload;
        this.tagNumber = tagNumber;
        this.tagClass = tagClass;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public BACnetTagPayloadBitString getPayload() {
        return this.payload;
    }

    public boolean getFirstItem() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 0 ? this.getPayload().getData().get(0) : false;
    }

    public boolean getLastItem() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 1 ? this.getPayload().getData().get(1) : false;
    }

    public boolean getMoreItems() {
        return StaticHelper.COUNT(this.getPayload().getData()) > 2 ? this.getPayload().getData().get(2) : false;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetResultFlagsTagged", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean firstItem = this.getFirstItem();
        writeBuffer.writeVirtual("firstItem", (Object)firstItem, new WithWriterArgs[0]);
        boolean lastItem = this.getLastItem();
        writeBuffer.writeVirtual("lastItem", (Object)lastItem, new WithWriterArgs[0]);
        boolean moreItems = this.getMoreItems();
        writeBuffer.writeVirtual("moreItems", (Object)moreItems, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetResultFlagsTagged", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetResultFlagsTagged _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.header.getLengthInBits();
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static BACnetResultFlagsTagged staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        TagClass tagClass;
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof TagClass) {
            tagClass = (TagClass)((Object)args[1]);
        } else if (args[1] instanceof String) {
            tagClass = TagClass.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type TagClass or a string which is parseable but was " + args[1].getClass().getName());
        }
        return BACnetResultFlagsTagged.staticParse(readBuffer, tagNumber, tagClass);
    }

    public static BACnetResultFlagsTagged staticParse(ReadBuffer readBuffer, Short tagNumber, TagClass tagClass) throws ParseException {
        readBuffer.pullContext("BACnetResultFlagsTagged", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getTagClass() != tagClass) {
            throw new ParseValidationException("tag class doesn't match");
        }
        if (header.getTagClass() != TagClass.APPLICATION_TAGS && header.getActualTagNumber() != tagNumber.shortValue()) {
            throw new ParseAssertException("tagnumber doesn't match");
        }
        BACnetTagPayloadBitString payload = (BACnetTagPayloadBitString)FieldReaderFactory.readSimpleField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> BACnetTagPayloadBitString.staticParse(readBuffer, header.getActualLength()), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean firstItem = (Boolean)FieldReaderFactory.readVirtualField((String)"firstItem", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 0 ? payload.getData().get(0) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean lastItem = (Boolean)FieldReaderFactory.readVirtualField((String)"lastItem", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 1 ? payload.getData().get(1) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean moreItems = (Boolean)FieldReaderFactory.readVirtualField((String)"moreItems", Boolean.TYPE, (Object)(StaticHelper.COUNT(payload.getData()) > 2 ? payload.getData().get(2) : false), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetResultFlagsTagged", new WithReaderArgs[0]);
        BACnetResultFlagsTagged _bACnetResultFlagsTagged = new BACnetResultFlagsTagged(header, payload, tagNumber, tagClass);
        return _bACnetResultFlagsTagged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetResultFlagsTagged)) {
            return false;
        }
        BACnetResultFlagsTagged that = (BACnetResultFlagsTagged)o;
        return this.getHeader() == that.getHeader() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getHeader(), this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

