/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAck;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckAtomicReadFileStreamOrRecord;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetServiceAckAtomicReadFile
extends BACnetServiceAck
implements Message {
    protected final BACnetApplicationTagBoolean endOfFile;
    protected final BACnetServiceAckAtomicReadFileStreamOrRecord accessMethod;
    protected final Long serviceAckLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.ATOMIC_READ_FILE;
    }

    public BACnetServiceAckAtomicReadFile(BACnetApplicationTagBoolean endOfFile, BACnetServiceAckAtomicReadFileStreamOrRecord accessMethod, Long serviceAckLength) {
        super(serviceAckLength);
        this.endOfFile = endOfFile;
        this.accessMethod = accessMethod;
        this.serviceAckLength = serviceAckLength;
    }

    public BACnetApplicationTagBoolean getEndOfFile() {
        return this.endOfFile;
    }

    public BACnetServiceAckAtomicReadFileStreamOrRecord getAccessMethod() {
        return this.accessMethod;
    }

    @Override
    protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetServiceAckAtomicReadFile", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endOfFile", (Object)this.endOfFile, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"accessMethod", (Object)this.accessMethod, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetServiceAckAtomicReadFile", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetServiceAckAtomicReadFile _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.endOfFile.getLengthInBits();
        return lengthInBits += this.accessMethod.getLengthInBits();
    }

    public static BACnetServiceAck.BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(ReadBuffer readBuffer, Long serviceAckLength) throws ParseException {
        readBuffer.pullContext("BACnetServiceAckAtomicReadFile", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagBoolean endOfFile = (BACnetApplicationTagBoolean)FieldReaderFactory.readSimpleField((String)"endOfFile", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagBoolean)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetServiceAckAtomicReadFileStreamOrRecord accessMethod = (BACnetServiceAckAtomicReadFileStreamOrRecord)FieldReaderFactory.readSimpleField((String)"accessMethod", (DataReader)new DataReaderComplexDefault(() -> BACnetServiceAckAtomicReadFileStreamOrRecord.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetServiceAckAtomicReadFile", new WithReaderArgs[0]);
        return new BACnetServiceAckAtomicReadFileBuilderImpl(endOfFile, accessMethod, serviceAckLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetServiceAckAtomicReadFile)) {
            return false;
        }
        BACnetServiceAckAtomicReadFile that = (BACnetServiceAckAtomicReadFile)o;
        return this.getEndOfFile() == that.getEndOfFile() && this.getAccessMethod() == that.getAccessMethod() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEndOfFile(), this.getAccessMethod());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetServiceAckAtomicReadFileBuilderImpl
    implements BACnetServiceAck.BACnetServiceAckBuilder {
        private final BACnetApplicationTagBoolean endOfFile;
        private final BACnetServiceAckAtomicReadFileStreamOrRecord accessMethod;
        private final Long serviceAckLength;

        public BACnetServiceAckAtomicReadFileBuilderImpl(BACnetApplicationTagBoolean endOfFile, BACnetServiceAckAtomicReadFileStreamOrRecord accessMethod, Long serviceAckLength) {
            this.endOfFile = endOfFile;
            this.accessMethod = accessMethod;
            this.serviceAckLength = serviceAckLength;
        }

        @Override
        public BACnetServiceAckAtomicReadFile build(Long serviceAckLength) {
            BACnetServiceAckAtomicReadFile bACnetServiceAckAtomicReadFile = new BACnetServiceAckAtomicReadFile(this.endOfFile, this.accessMethod, serviceAckLength);
            return bACnetServiceAckAtomicReadFile;
        }
    }
}

