/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAck;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetServiceAckAtomicWriteFile
extends BACnetServiceAck
implements Message {
    protected final BACnetContextTagSignedInteger fileStartPosition;
    protected final Long serviceAckLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.ATOMIC_WRITE_FILE;
    }

    public BACnetServiceAckAtomicWriteFile(BACnetContextTagSignedInteger fileStartPosition, Long serviceAckLength) {
        super(serviceAckLength);
        this.fileStartPosition = fileStartPosition;
        this.serviceAckLength = serviceAckLength;
    }

    public BACnetContextTagSignedInteger getFileStartPosition() {
        return this.fileStartPosition;
    }

    @Override
    protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetServiceAckAtomicWriteFile", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"fileStartPosition", (Object)this.fileStartPosition, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetServiceAckAtomicWriteFile", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetServiceAckAtomicWriteFile _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.fileStartPosition.getLengthInBits();
    }

    public static BACnetServiceAck.BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(ReadBuffer readBuffer, Long serviceAckLength) throws ParseException {
        readBuffer.pullContext("BACnetServiceAckAtomicWriteFile", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagSignedInteger fileStartPosition = (BACnetContextTagSignedInteger)FieldReaderFactory.readSimpleField((String)"fileStartPosition", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagSignedInteger)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.SIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetServiceAckAtomicWriteFile", new WithReaderArgs[0]);
        return new BACnetServiceAckAtomicWriteFileBuilderImpl(fileStartPosition, serviceAckLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetServiceAckAtomicWriteFile)) {
            return false;
        }
        BACnetServiceAckAtomicWriteFile that = (BACnetServiceAckAtomicWriteFile)o;
        return this.getFileStartPosition() == that.getFileStartPosition() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFileStartPosition());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetServiceAckAtomicWriteFileBuilderImpl
    implements BACnetServiceAck.BACnetServiceAckBuilder {
        private final BACnetContextTagSignedInteger fileStartPosition;
        private final Long serviceAckLength;

        public BACnetServiceAckAtomicWriteFileBuilderImpl(BACnetContextTagSignedInteger fileStartPosition, Long serviceAckLength) {
            this.fileStartPosition = fileStartPosition;
            this.serviceAckLength = serviceAckLength;
        }

        @Override
        public BACnetServiceAckAtomicWriteFile build(Long serviceAckLength) {
            BACnetServiceAckAtomicWriteFile bACnetServiceAckAtomicWriteFile = new BACnetServiceAckAtomicWriteFile(this.fileStartPosition, serviceAckLength);
            return bACnetServiceAckAtomicWriteFile;
        }
    }
}

